/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.bedpe;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.bedpe.BedPEFeature;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;

public class BedPEParser {
    private static Logger log = Logger.getLogger(BedPEParser.class);

    public static List<BedPEFeature> parse(String file) throws IOException {
        String nextLine;
        int colorColumn = -1;
        int thicknessColumn = -1;
        HashMap<String, Color> colorCache = new HashMap<String, Color>();
        ArrayList<BedPEFeature> features = new ArrayList<BedPEFeature>();
        BufferedReader br = null;
        br = ParsingUtils.openBufferedReader(file);
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.startsWith("#")) {
                if (!nextLine.startsWith("#columns")) continue;
                try {
                    String[] t2;
                    String[] t1 = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                    if (t1.length != 2) continue;
                    for (String keyValue : t2 = ParsingUtils.SEMI_COLON_PATTERN.split(t1[1])) {
                        String[] t = keyValue.split("=");
                        if (t[0].equals("color")) {
                            colorColumn = Integer.parseInt(t[1]) - 1;
                            continue;
                        }
                        if (!t[0].equals("thickness")) continue;
                        thicknessColumn = Integer.parseInt(t[1]) - 1;
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error("Error parsing #column line.", e);
                    continue;
                }
            }
            String[] tokens2 = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
            if (tokens2.length < 6) {
                log.info("Skipping line: " + nextLine);
                continue;
            }
            BedPEFeature feature = new BedPEFeature();
            feature.chr1 = tokens2[0];
            feature.start1 = Integer.parseInt(tokens2[1]);
            feature.end1 = Integer.parseInt(tokens2[2]);
            feature.chr2 = tokens2[3];
            feature.start2 = Integer.parseInt(tokens2[4]);
            feature.end2 = Integer.parseInt(tokens2[5]);
            if (tokens2.length > 6) {
                feature.name = tokens2[6];
            }
            if (tokens2.length > 7) {
                feature.score = tokens2[7];
            }
            if (colorColumn > 0) {
                String colorString = tokens2[colorColumn];
                Color c = (Color)colorCache.get(colorString);
                if (c == null) {
                    c = ColorUtilities.stringToColor(colorString);
                    colorCache.put(colorString, c);
                }
                feature.color = c;
            }
            if (thicknessColumn > 0) {
                feature.thickness = Integer.parseInt(tokens2[thicknessColumn]);
            }
            features.add(feature);
        }
        return features;
    }
}

