/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.CufflinksCodec;
import org.broad.igv.data.cufflinks.FPKMValue;
import org.broad.igv.feature.Locus;
import org.broad.igv.util.ParsingUtils;

public class FPKMTrackingCodec
extends CufflinksCodec<FPKMValue> {
    private static Logger log = Logger.getLogger(FPKMTrackingCodec.class);
    int geneColumn = 4;
    int locusColumn = 6;
    static final int startfpkmCol = 9;
    static final int colsPerSample = 4;
    private int numSamples = 1;

    public FPKMTrackingCodec(String path) {
        super(FPKMValue.class, path);
    }

    @Override
    public Object readHeader(String[] tokens2) {
        for (int i = 0; i < tokens2.length; ++i) {
            String tk = tokens2[i];
            if (tk.equals("locus")) {
                this.locusColumn = i;
                continue;
            }
            if (!tk.equals("gene_short_name")) continue;
            this.geneColumn = i;
        }
        this.numSamples = (tokens2.length - 9) / 4;
        return tokens2;
    }

    @Override
    public FPKMValue decode(String line) {
        return this.decode(ParsingUtils.TAB_PATTERN.split(line));
    }

    @Override
    public FPKMValue decode(String[] tokens2) {
        if (tokens2[0].equalsIgnoreCase("tracking_id") || tokens2[this.geneColumn].equalsIgnoreCase("gene_short_name")) {
            return null;
        }
        if (tokens2.length >= 9 + this.numSamples * 4) {
            String locusString = tokens2[this.locusColumn];
            if (locusString == null) {
                return null;
            }
            Locus locus = Locus.fromString(locusString);
            if (locus == null || locus.getChr() == null) {
                return null;
            }
            String gene = tokens2[this.geneColumn];
            float[] fpkm = new float[this.numSamples];
            float[] confLo = new float[this.numSamples];
            float[] confHi = new float[this.numSamples];
            for (int sampNum = 0; sampNum < this.numSamples; ++sampNum) {
                int startCol = 9 + sampNum * 4;
                fpkm[sampNum] = Float.parseFloat(tokens2[startCol]);
                confLo[sampNum] = Float.parseFloat(tokens2[startCol + 1]);
                confHi[sampNum] = Float.parseFloat(tokens2[startCol + 2]);
            }
            return new FPKMValue(locus.getChr(), locus.getStart() - 1, locus.getEnd(), gene, fpkm, confLo, confHi);
        }
        log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens2.length);
        return null;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    @Override
    public boolean canDecode(String path) {
        String fn = path.toLowerCase();
        if (fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.length() - 3);
        }
        return fn.endsWith("fpkm_tracking");
    }
}

