/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.cufflinks;

import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.CufflinksCodec;
import org.broad.igv.data.cufflinks.ExpDiffValue;
import org.broad.igv.feature.Locus;
import org.broad.igv.util.ParsingUtils;

public class ExpDiffCodec
extends CufflinksCodec<ExpDiffValue> {
    private static Logger log = Logger.getLogger(ExpDiffCodec.class);
    int geneColumn = 1;
    int locusColumn = 2;
    int xColumn = 6;
    int yColumn = 7;
    int logRatioColumn = 8;
    int sigColumn = 12;

    public ExpDiffCodec(String path) {
        super(ExpDiffValue.class, path);
    }

    @Override
    public Object readHeader(String[] tokens2) {
        for (int i = 0; i < tokens2.length; ++i) {
            String tk = tokens2[i];
            if (tk.equals("locus")) {
                this.locusColumn = i;
                continue;
            }
            if (tk.equals("gene")) {
                this.geneColumn = i;
                continue;
            }
            if (tk.equals("value_1")) {
                this.xColumn = i;
                continue;
            }
            if (tk.equals("value_2")) {
                this.yColumn = i;
                continue;
            }
            if (tk.startsWith("log2(")) {
                this.logRatioColumn = i;
                continue;
            }
            if (!tk.equals("significant")) continue;
            this.sigColumn = i;
        }
        return tokens2;
    }

    @Override
    public ExpDiffValue decode(String[] tokens2) {
        if (tokens2[0].equalsIgnoreCase("test_id") || tokens2[this.geneColumn].equalsIgnoreCase("gene_id")) {
            return null;
        }
        if (tokens2.length >= this.sigColumn) {
            String locusString = tokens2[this.locusColumn];
            if (locusString == null) {
                return null;
            }
            Locus locus = Locus.fromString(locusString);
            if (locus == null || locus.getChr() == null) {
                return null;
            }
            String logRatioStr = tokens2[this.logRatioColumn];
            float logRatio = Float.parseFloat(logRatioStr);
            if (Float.isInfinite(logRatio) || Float.isNaN(logRatio)) {
                log.info("LogRatio " + logRatioStr + " cannot be parsed as a float");
                logRatio = Float.NaN;
            }
            float fpkmX = Float.parseFloat(tokens2[this.xColumn]);
            float fpkmY = Float.parseFloat(tokens2[this.yColumn]);
            String gene = tokens2[this.geneColumn];
            String significant = tokens2[this.sigColumn];
            return new ExpDiffValue(locus.getChr(), locus.getStart() - 1, locus.getEnd(), gene, logRatio, fpkmX, fpkmY, significant);
        }
        log.info("Unexpected # of columns.  Expected at least 12,  found " + tokens2.length);
        return null;
    }

    @Override
    public ExpDiffValue decode(String line) {
        return this.decode(ParsingUtils.TAB_PATTERN.split(line));
    }

    @Override
    public boolean canDecode(String path) {
        String s = path.toLowerCase();
        if (s.endsWith(".gz")) {
            s = s.substring(0, s.length() - 3);
        }
        return s.endsWith("gene_exp.diff") || s.endsWith("cds_exp.diff");
    }
}

