/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broad.igv.data.Dataset;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ArrayHeapIntSorter;
import org.broad.igv.util.IntComparator;
import org.broad.igv.util.collections.FloatArrayList;
import org.broad.igv.util.collections.IntArrayList;

public class WiggleDataset
implements Dataset {
    Genome genome;
    private String name;
    private TrackProperties trackProperties;
    Map<String, IntArrayList> startLocationsMap = new HashMap<String, IntArrayList>();
    Map<String, IntArrayList> endLocationsMap = new HashMap<String, IntArrayList>();
    Map<String, FloatArrayList> dataMap = new HashMap<String, FloatArrayList>();
    float dataMin = 0.0f;
    float dataMax = 0.0f;
    float percent90 = 0.0f;
    float percent10 = 0.0f;
    private Map<String, Integer> longestFeatureMap;
    private TrackType type = TrackType.OTHER;

    public WiggleDataset(Genome genome, String name) {
        this.genome = genome;
        this.name = name;
        this.trackProperties = new TrackProperties();
    }

    public void sort(Set<String> unsortedChromosomes) {
        for (String c : unsortedChromosomes) {
            String chr = this.genome.getCanonicalChrName(c);
            final IntArrayList starts = this.startLocationsMap.get(chr);
            int sz = starts.size();
            int[] indices = new int[sz];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            new ArrayHeapIntSorter().sort(indices, new IntComparator(){

                @Override
                public int compare(int arg0, int arg1) {
                    return starts.get(arg0) - starts.get(arg1);
                }
            });
            int[] sortedStarts = this.reorder(indices, this.startLocationsMap.get(chr));
            int[] sortedEnds = this.reorder(indices, this.endLocationsMap.get(chr));
            float[] sortedData = this.reorder(indices, this.dataMap.get(chr));
            this.startLocationsMap.put(chr, new IntArrayList(sortedStarts));
            this.endLocationsMap.put(chr, new IntArrayList(sortedEnds));
            this.dataMap.put(chr, new FloatArrayList(sortedData));
        }
    }

    private float[] reorder(int[] indices, FloatArrayList values2) {
        int size = values2.size();
        if (indices.length != size) {
            throw new IllegalArgumentException("Index array length not equal to size");
        }
        float[] reorderedValues = new float[size];
        for (int i = 0; i < size; ++i) {
            reorderedValues[i] = values2.get(indices[i]);
        }
        return reorderedValues;
    }

    private int[] reorder(int[] indices, IntArrayList values2) {
        int size = values2.size();
        if (indices.length != size) {
            throw new IllegalArgumentException("Index array length not equal to size");
        }
        int[] reorderedValues = new int[size];
        for (int i = 0; i < size; ++i) {
            reorderedValues[i] = values2.get(indices[i]);
        }
        return reorderedValues;
    }

    public void addDataChunk(String chr, IntArrayList starts, IntArrayList ends, FloatArrayList data) {
        FloatArrayList dataArray;
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        if (startLocations == null) {
            this.startLocationsMap.put(chr, starts);
        } else {
            startLocations.addAll(starts);
        }
        if (ends != null) {
            IntArrayList endLocations = this.endLocationsMap.get(chr);
            if (endLocations == null) {
                this.endLocationsMap.put(chr, ends);
            } else {
                endLocations.addAll(ends);
            }
        }
        if ((dataArray = this.dataMap.get(chr)) == null) {
            this.dataMap.put(chr, data);
        } else {
            dataArray.addAll(data);
        }
        float[] d = data.toArray();
        for (int i = 0; i < d.length; ++i) {
            this.dataMax = Math.max(this.dataMax, d[i]);
            this.dataMin = Math.min(this.dataMin, d[i]);
        }
    }

    @Override
    public float getDataMin() {
        return this.dataMin;
    }

    @Override
    public float getDataMax() {
        return this.dataMax;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TrackType getType() {
        return this.type;
    }

    @Override
    public String[] getChromosomes() {
        return this.startLocationsMap.keySet().toArray(new String[0]);
    }

    boolean containsChromosome(String chr) {
        String datChr = this.genome != null ? this.genome.getCanonicalChrName(chr) : chr;
        return this.startLocationsMap.containsKey(datChr);
    }

    @Override
    public String[] getTrackNames() {
        return new String[]{this.getName()};
    }

    @Override
    public int[] getStartLocations(String chr) {
        IntArrayList startLocations = this.startLocationsMap.get(chr);
        if (startLocations == null) {
            return null;
        }
        return startLocations.toArray();
    }

    @Override
    public int[] getEndLocations(String chr) {
        IntArrayList endLocations = this.endLocationsMap.get(chr);
        if (endLocations == null) {
            return null;
        }
        return endLocations.toArray();
    }

    @Override
    public float[] getData(String heading, String chr) {
        FloatArrayList data = this.dataMap.get(chr);
        if (data == null) {
            return null;
        }
        return data.toArray();
    }

    @Override
    public String[] getFeatureNames(String chr) {
        return null;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    @Override
    public Integer getLongestFeature(String chr) {
        return this.longestFeatureMap == null ? Integer.valueOf(1000) : (this.longestFeatureMap.containsKey(chr) ? this.longestFeatureMap.get(chr) : Integer.valueOf(1));
    }

    public void setLongestFeatureMap(Map<String, Integer> longestFeatureMap) {
        this.longestFeatureMap = longestFeatureMap;
    }

    public void setType(TrackType type) {
        this.type = type;
    }

    public void setPercent10(float percent10) {
        this.percent10 = percent10;
    }

    public float getPercent10() {
        return this.percent10;
    }

    public void setPercent90(float percent90) {
        this.percent90 = percent90;
    }

    public float getPercent90() {
        return this.percent90;
    }
}

