/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import org.broad.igv.data.IGVDataset;
import org.broad.igv.track.TrackType;
import org.broad.igv.util.ParsingUtils;

public class AbstractDataParser {
    protected void parseDirective(String comment, IGVDataset dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            ParsingUtils.parseTrackLine(tmp, dataset.getTrackProperties());
        } else {
            String[] tokens2 = tmp.split("=");
            if (tokens2.length != 2) {
                return;
            }
            String key = tokens2[0].trim().toLowerCase();
            if (key.equals("name")) {
                dataset.setName(tokens2[1].trim());
            } else if (key.equals("type")) {
                try {
                    dataset.setTrackType(TrackType.valueOf(tokens2[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

