/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NotPositiveException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.util.Localizable;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    private double[] storedData;

    public void setData(double[] values2) {
        this.storedData = values2 == null ? null : (double[])values2.clone();
    }

    public double[] getData() {
        return this.storedData == null ? null : (double[])this.storedData.clone();
    }

    protected double[] getDataRef() {
        return this.storedData;
    }

    public void setData(double[] values2, int begin, int length) {
        this.storedData = new double[length];
        System.arraycopy(values2, begin, this.storedData, 0, length);
    }

    public double evaluate() {
        return this.evaluate(this.storedData);
    }

    public double evaluate(double[] values2) {
        this.test(values2, 0, 0);
        return this.evaluate(values2, 0, values2.length);
    }

    public abstract double evaluate(double[] var1, int var2, int var3);

    public abstract UnivariateStatistic copy();

    protected boolean test(double[] values2, int begin, int length) {
        if (values2 == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        if (begin < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, begin);
        }
        if (length < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, length);
        }
        if (begin + length > values2.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, new Object[0]);
        }
        return length != 0;
    }

    protected boolean test(double[] values2, double[] weights, int begin, int length) {
        if (weights == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        if (weights.length != values2.length) {
            throw new DimensionMismatchException(weights.length, values2.length);
        }
        boolean containsPositiveWeight = false;
        for (int i = begin; i < begin + length; ++i) {
            if (Double.isNaN(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i);
            }
            if (Double.isInfinite(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, weights[i], i);
            }
            if (weights[i] < 0.0) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i, weights[i]);
            }
            if (containsPositiveWeight || !(weights[i] > 0.0)) continue;
            containsPositiveWeight = true;
        }
        if (!containsPositiveWeight) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        return this.test(values2, begin, length);
    }
}

