/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.apache.commons.math.stat.descriptive.rank.Max;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.apache.commons.math.stat.descriptive.rank.Percentile;
import org.apache.commons.math.stat.descriptive.summary.Product;
import org.apache.commons.math.stat.descriptive.summary.Sum;
import org.apache.commons.math.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;

public final class StatUtils {
    private static final UnivariateStatistic SUM = new Sum();
    private static final UnivariateStatistic SUM_OF_SQUARES = new SumOfSquares();
    private static final UnivariateStatistic PRODUCT = new Product();
    private static final UnivariateStatistic SUM_OF_LOGS = new SumOfLogs();
    private static final UnivariateStatistic MIN = new Min();
    private static final UnivariateStatistic MAX = new Max();
    private static final UnivariateStatistic MEAN = new Mean();
    private static final Variance VARIANCE = new Variance();
    private static final Percentile PERCENTILE = new Percentile();
    private static final GeometricMean GEOMETRIC_MEAN = new GeometricMean();

    private StatUtils() {
    }

    public static double sum(double[] values2) {
        return SUM.evaluate(values2);
    }

    public static double sum(double[] values2, int begin, int length) {
        return SUM.evaluate(values2, begin, length);
    }

    public static double sumSq(double[] values2) {
        return SUM_OF_SQUARES.evaluate(values2);
    }

    public static double sumSq(double[] values2, int begin, int length) {
        return SUM_OF_SQUARES.evaluate(values2, begin, length);
    }

    public static double product(double[] values2) {
        return PRODUCT.evaluate(values2);
    }

    public static double product(double[] values2, int begin, int length) {
        return PRODUCT.evaluate(values2, begin, length);
    }

    public static double sumLog(double[] values2) {
        return SUM_OF_LOGS.evaluate(values2);
    }

    public static double sumLog(double[] values2, int begin, int length) {
        return SUM_OF_LOGS.evaluate(values2, begin, length);
    }

    public static double mean(double[] values2) {
        return MEAN.evaluate(values2);
    }

    public static double mean(double[] values2, int begin, int length) {
        return MEAN.evaluate(values2, begin, length);
    }

    public static double geometricMean(double[] values2) {
        return GEOMETRIC_MEAN.evaluate(values2);
    }

    public static double geometricMean(double[] values2, int begin, int length) {
        return GEOMETRIC_MEAN.evaluate(values2, begin, length);
    }

    public static double variance(double[] values2) {
        return VARIANCE.evaluate(values2);
    }

    public static double variance(double[] values2, int begin, int length) {
        return VARIANCE.evaluate(values2, begin, length);
    }

    public static double variance(double[] values2, double mean, int begin, int length) {
        return VARIANCE.evaluate(values2, mean, begin, length);
    }

    public static double variance(double[] values2, double mean) {
        return VARIANCE.evaluate(values2, mean);
    }

    public static double max(double[] values2) {
        return MAX.evaluate(values2);
    }

    public static double max(double[] values2, int begin, int length) {
        return MAX.evaluate(values2, begin, length);
    }

    public static double min(double[] values2) {
        return MIN.evaluate(values2);
    }

    public static double min(double[] values2, int begin, int length) {
        return MIN.evaluate(values2, begin, length);
    }

    public static double percentile(double[] values2, double p) {
        return PERCENTILE.evaluate(values2, p);
    }

    public static double percentile(double[] values2, int begin, int length, double p) {
        return PERCENTILE.evaluate(values2, begin, length, p);
    }

    public static double sumDifference(double[] sample1, double[] sample2) throws IllegalArgumentException {
        int n = sample1.length;
        if (n != sample2.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, n, sample2.length);
        }
        if (n < 1) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, sample2.length, 1);
        }
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            result += sample1[i] - sample2[i];
        }
        return result;
    }

    public static double meanDifference(double[] sample1, double[] sample2) throws IllegalArgumentException {
        return StatUtils.sumDifference(sample1, sample2) / (double)sample1.length;
    }

    public static double varianceDifference(double[] sample1, double[] sample2, double meanDifference) throws IllegalArgumentException {
        double sum1 = 0.0;
        double sum2 = 0.0;
        double diff = 0.0;
        int n = sample1.length;
        if (n != sample2.length) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, n, sample2.length);
        }
        if (n < 2) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.INSUFFICIENT_DIMENSION, n, 2);
        }
        for (int i = 0; i < n; ++i) {
            diff = sample1[i] - sample2[i];
            sum1 += (diff - meanDifference) * (diff - meanDifference);
            sum2 += diff - meanDifference;
        }
        return (sum1 - sum2 * sum2 / (double)n) / (double)(n - 1);
    }

    public static double[] normalize(double[] sample) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        for (int i = 0; i < sample.length; ++i) {
            stats.addValue(sample[i]);
        }
        double mean = stats.getMean();
        double standardDeviation = stats.getStandardDeviation();
        double[] standardizedSample = new double[sample.length];
        for (int i = 0; i < sample.length; ++i) {
            standardizedSample[i] = (sample[i] - mean) / standardDeviation;
        }
        return standardizedSample;
    }
}

