/*
 * Decompiled with CFR 0.152.
 */
package javastraw.tools;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelizationTools {
    public static void launchParallelizedCode(Runnable runnable) {
        ParallelizationTools.launchParallelizedCode(Runtime.getRuntime().availableProcessors(), runnable);
    }

    public static void launchParallelizedCode(int numCPUThreads, final Runnable runnable) {
        ExecutorService executor = Executors.newFixedThreadPool(numCPUThreads);
        for (int l = 0; l < numCPUThreads; ++l) {
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                }
            };
            executor.execute(worker);
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
    }

    public static void shutDownServiceAndWait(ExecutorService service, AtomicInteger errorCounter) {
        service.shutdown();
        try {
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            System.err.println("Error " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        if (errorCounter.get() > 0) {
            System.err.println(errorCounter.get() + " errors during process");
        }
    }

    public static void shutDownAndWaitUntilDone(ExecutorService executor, int milliseconds) {
        executor.shutdown();
        while (!executor.isTerminated()) {
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException e) {
                System.err.println(e.getLocalizedMessage());
            }
        }
    }
}

