/*
 * Decompiled with CFR 0.152.
 */
package javastraw.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javastraw.reader.block.ContactRecord;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.jetbrains.bio.npy.NpyFile;

public class MatrixTools {
    public static RealMatrix cleanArray2DMatrix(int n) {
        return MatrixTools.cleanArray2DMatrix(n, n);
    }

    public static RealMatrix cleanArray2DMatrix(int rows, int cols) {
        return MatrixTools.presetValueMatrix(rows, cols, 0);
    }

    public static RealMatrix presetValueMatrix(int numRows, int numCols, int val) {
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(numRows, numCols);
        for (int r = 0; r < numRows; ++r) {
            for (int c = 0; c < numCols; ++c) {
                matrix.setEntry(r, c, val);
            }
        }
        return matrix;
    }

    public static RealMatrix randomUnitMatrix(int rows, int cols) {
        Random generator = new Random();
        RealMatrix matrix = MatrixTools.cleanArray2DMatrix(rows, cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                if (!generator.nextBoolean()) continue;
                matrix.setEntry(r, c, 1.0);
            }
        }
        return matrix;
    }

    public static double minimumPositive(double[][] data) {
        double minVal = Double.MAX_VALUE;
        double[][] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double val : row = dArray[i]) {
                if (!(val > 0.0) || !(val < minVal)) continue;
                minVal = val;
            }
        }
        if (minVal == Double.MAX_VALUE) {
            minVal = 0.0;
        }
        return minVal;
    }

    public static double[] flattenedRowMajorOrderMatrix(double[][] matrix) {
        int m = matrix.length;
        int n = matrix[0].length;
        int numElements = m * n;
        double[] flattenedMatrix = new double[numElements];
        int index = 0;
        for (double[] doubles : matrix) {
            System.arraycopy(doubles, 0, flattenedMatrix, index, n);
            index += n;
        }
        return flattenedMatrix;
    }

    public static float[] flattenedRowMajorOrderMatrix(float[][] matrix) {
        int m = matrix.length;
        int n = matrix[0].length;
        int numElements = m * n;
        float[] flattenedMatrix = new float[numElements];
        int index = 0;
        for (float[] floats : matrix) {
            System.arraycopy(floats, 0, flattenedMatrix, index, n);
            index += n;
        }
        return flattenedMatrix;
    }

    public static int[] flattenedRowMajorOrderMatrix(int[][] matrix) {
        int m = matrix.length;
        int n = matrix[0].length;
        int numElements = m * n;
        int[] flattenedMatrix = new int[numElements];
        int index = 0;
        for (int[] ints : matrix) {
            System.arraycopy(ints, 0, flattenedMatrix, index, n);
            index += n;
        }
        return flattenedMatrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMatrixText(String filename, RealMatrix realMatrix) {
        Writer writer = null;
        try {
            double[][] matrix;
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            for (double[] row : matrix = realMatrix.getData()) {
                writer.write(Arrays.toString(row) + "\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static float[][] reshapeFlatMatrix(float[] flatMatrix, int n) {
        return MatrixTools.reshapeFlatMatrix(flatMatrix, n, n);
    }

    public static float[][] reshapeFlatMatrix(float[] flatMatrix, int numRows, int numCols) {
        float[][] matrix = new float[numRows][numCols];
        for (int i = 0; i < numRows; ++i) {
            System.arraycopy(flatMatrix, i * numCols, matrix[i], 0, numCols);
        }
        return matrix;
    }

    public static float[][] extractLocalMatrixRegion(float[][] matrix, int r1, int r2, int c1, int c2) {
        int numRows = r2 - r1;
        int numColumns = c2 - c1;
        float[][] extractedRegion = new float[numRows][numColumns];
        for (int i = 0; i < numRows; ++i) {
            System.arraycopy(matrix[r1 + i], c1, extractedRegion[i], 0, numColumns);
        }
        return extractedRegion;
    }

    public static RealMatrix extractLocalMatrixRegion(RealMatrix matrix, int r1, int r2, int c1, int c2) {
        int numRows = r2 - r1;
        int numColumns = c2 - c1;
        RealMatrix extractedRegion = MatrixTools.cleanArray2DMatrix(numRows, numColumns);
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                extractedRegion.setEntry(i, j, matrix.getEntry(r1 + i, c1 + j));
            }
        }
        return extractedRegion;
    }

    public static RealMatrix extractDiagonal(RealMatrix matrix) {
        int n = Math.min(matrix.getColumnDimension(), matrix.getRowDimension());
        RealMatrix diagonal = MatrixTools.cleanArray2DMatrix(n);
        for (int i = 0; i < n; ++i) {
            diagonal.setEntry(i, i, matrix.getEntry(i, i));
        }
        return diagonal;
    }

    public static RealMatrix makeSymmetricMatrix(RealMatrix matrix) {
        RealMatrix symmetricMatrix = MatrixTools.extractDiagonal(matrix);
        int n = symmetricMatrix.getRowDimension();
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double val = matrix.getEntry(i, j);
                symmetricMatrix.setEntry(i, j, val);
                symmetricMatrix.setEntry(j, i, val);
            }
        }
        return symmetricMatrix;
    }

    public static RealMatrix flipAcrossAntiDiagonal(RealMatrix matrix) {
        int n = Math.min(matrix.getColumnDimension(), matrix.getRowDimension());
        RealMatrix antiDiagFlippedMatrix = MatrixTools.cleanArray2DMatrix(n, n);
        int maxIndex = n - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                antiDiagFlippedMatrix.setEntry(maxIndex - j, maxIndex - i, matrix.getEntry(i, j));
            }
        }
        return antiDiagFlippedMatrix;
    }

    public static RealMatrix flipLeftRight(RealMatrix matrix) {
        int r = matrix.getRowDimension();
        int c = matrix.getColumnDimension();
        RealMatrix leftRightFlippedMatrix = MatrixTools.cleanArray2DMatrix(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                leftRightFlippedMatrix.setEntry(i, c - 1 - j, matrix.getEntry(i, j));
            }
        }
        return leftRightFlippedMatrix;
    }

    public static RealMatrix flipTopBottom(RealMatrix matrix) {
        int r = matrix.getRowDimension();
        int c = matrix.getColumnDimension();
        RealMatrix topBottomFlippedMatrix = MatrixTools.cleanArray2DMatrix(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                topBottomFlippedMatrix.setEntry(r - 1 - i, j, matrix.getEntry(i, j));
            }
        }
        return topBottomFlippedMatrix;
    }

    public static RealMatrix elementBasedMultiplication(RealMatrix matrix1, RealMatrix matrix2) {
        int r = Math.min(matrix1.getRowDimension(), matrix2.getRowDimension());
        int c = Math.min(matrix1.getColumnDimension(), matrix2.getColumnDimension());
        RealMatrix elementwiseMultipliedMatrix = MatrixTools.cleanArray2DMatrix(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                elementwiseMultipliedMatrix.setEntry(i, j, matrix1.getEntry(i, j) * matrix2.getEntry(i, j));
            }
        }
        return elementwiseMultipliedMatrix;
    }

    public static RealMatrix elementBasedDivision(RealMatrix matrix1, RealMatrix matrix2) {
        int r = Math.min(matrix1.getRowDimension(), matrix2.getRowDimension());
        int c = Math.min(matrix1.getColumnDimension(), matrix2.getColumnDimension());
        RealMatrix elementwiseDividedMatrix = MatrixTools.cleanArray2DMatrix(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                elementwiseDividedMatrix.setEntry(i, j, matrix1.getEntry(i, j) / matrix2.getEntry(i, j));
            }
        }
        return elementwiseDividedMatrix;
    }

    public static void setNaNs(RealMatrix matrix, int val) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                if (!Double.isNaN(matrix.getEntry(i, j))) continue;
                matrix.setEntry(i, j, val);
            }
        }
    }

    public static RealMatrix sign(RealMatrix matrix) {
        int r = matrix.getRowDimension();
        int c = matrix.getColumnDimension();
        RealMatrix signMatrix = MatrixTools.cleanArray2DMatrix(r, c);
        for (int i = 0; i < r; ++i) {
            for (int j = 0; j < c; ++j) {
                double val = matrix.getEntry(i, j);
                if (val > 0.0) {
                    signMatrix.setEntry(i, j, 1.0);
                    continue;
                }
                if (!(val < 0.0)) continue;
                signMatrix.setEntry(i, j, -1.0);
            }
        }
        return signMatrix;
    }

    public static void replaceValue(RealMatrix matrix, int initialVal, int newVal) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                if (matrix.getEntry(i, j) != (double)initialVal) continue;
                matrix.setEntry(i, j, newVal);
            }
        }
    }

    public static RealMatrix normalizeByMax(RealMatrix matrix) {
        double max = MatrixTools.calculateMax(matrix);
        return matrix.scalarMultiply(1.0 / max);
    }

    public static double calculateMax(RealMatrix matrix) {
        double max = matrix.getEntry(0, 0);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                double val = matrix.getEntry(i, j);
                if (!(max < val)) continue;
                max = val;
            }
        }
        return max;
    }

    public static double calculateMin(RealMatrix matrix) {
        double min = matrix.getEntry(0, 0);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                double val = matrix.getEntry(i, j);
                if (!(min > val)) continue;
                min = val;
            }
        }
        return min;
    }

    public static void print(RealMatrix matrix) {
        MatrixTools.print(matrix.getData());
    }

    public static void print(double[][] data) {
        for (double[] row : data) {
            System.out.println(Arrays.toString(row));
        }
    }

    public static void print(float[][] data) {
        for (float[] row : data) {
            System.out.println(Arrays.toString(row));
        }
    }

    public static RealMatrix getSubMatrix(RealMatrix matrix, int[] indices) {
        return matrix.getSubMatrix(indices[0], indices[1], indices[2], indices[3]);
    }

    public static RealMatrix fillLowerLeftTriangle(RealMatrix matrix) {
        for (int r = 0; r < matrix.getRowDimension(); ++r) {
            for (int c = 0; c < matrix.getColumnDimension(); ++c) {
                matrix.setEntry(c, r, matrix.getEntry(r, c));
            }
        }
        return matrix;
    }

    public static void thresholdValues(RealMatrix matrix, int val) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                if (!(matrix.getEntry(i, j) > (double)val)) continue;
                matrix.setEntry(i, j, val);
            }
        }
    }

    public static void thresholdValuesDouble(RealMatrix matrix, double lowVal, double highVal) {
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                if (matrix.getEntry(i, j) > highVal) {
                    matrix.setEntry(i, j, highVal);
                }
                if (!(matrix.getEntry(i, j) < lowVal)) continue;
                matrix.setEntry(i, j, lowVal);
            }
        }
    }

    public static int[][] normalizeMatrixUsingColumnSum(int[][] matrix) {
        int[][] newMatrix = new int[matrix.length][matrix[0].length];
        int[] columnSum = new int[matrix[0].length];
        for (int[] row : matrix) {
            for (int i = 0; i < row.length; ++i) {
                int n = i;
                columnSum[n] = columnSum[n] + row[i];
            }
        }
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                newMatrix[i][j] = matrix[i][j] / columnSum[j];
            }
        }
        return newMatrix;
    }

    public static int[][] normalizeMatrixUsingRowSum(int[][] matrix) {
        int[][] newMatrix = new int[matrix.length][matrix[0].length];
        int[] rowSum = MatrixTools.getRowSums(matrix);
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                newMatrix[i][j] = matrix[i][j] / rowSum[i];
            }
        }
        return newMatrix;
    }

    public static int[] getRowSums(int[][] matrix) {
        int[] rowSum = new int[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int val : matrix[i]) {
                int n = i;
                rowSum[n] = rowSum[n] + val;
            }
        }
        return rowSum;
    }

    public static double[] getRowSums(double[][] matrix) {
        double[] rowSum = new double[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (double val : matrix[i]) {
                int n = i;
                rowSum[n] = rowSum[n] + val;
            }
        }
        return rowSum;
    }

    public static float[] getAbsValColSums(float[][] matrix) {
        float[] colSum = new float[matrix[0].length];
        for (float[] floats : matrix) {
            for (int j = 0; j < floats.length; ++j) {
                int n = j;
                colSum[n] = colSum[n] + Math.abs(floats[j]);
            }
        }
        return colSum;
    }

    public static int[] getAbsValColSums(int[][] matrix) {
        int[] colSum = new int[matrix[0].length];
        for (int[] ints : matrix) {
            for (int j = 0; j < ints.length; ++j) {
                int n = j;
                colSum[n] = colSum[n] + Math.abs(ints[j]);
            }
        }
        return colSum;
    }

    public static float[] getRowSums(float[][] matrix) {
        float[] rowSum = new float[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (float val : matrix[i]) {
                int n = i;
                rowSum[n] = rowSum[n] + val;
            }
        }
        return rowSum;
    }

    public static double[] getRowSums(List<ContactRecord> unNormedRecordList, double scalar, double[] normVector) {
        double[] rowSum = new double[normVector.length];
        for (ContactRecord record : unNormedRecordList) {
            int x = record.getBinX();
            int y = record.getBinY();
            float counts = record.getCounts();
            double normVal = (double)counts * scalar / (normVector[x] * normVector[y]);
            int n = x;
            rowSum[n] = rowSum[n] + normVal;
            if (x == y) continue;
            int n2 = y;
            rowSum[n2] = rowSum[n2] + normVal;
        }
        return rowSum;
    }

    public static void cleanUpNaNs(RealMatrix matrix) {
        for (int r = 0; r < matrix.getRowDimension(); ++r) {
            for (int c = 0; c < matrix.getColumnDimension(); ++c) {
                if (!Double.isNaN(matrix.getEntry(r, c))) continue;
                matrix.setEntry(r, c, 0.0);
            }
        }
    }

    public static void cleanUpNaNs(double[][] matrix) {
        for (int r = 0; r < matrix.length; ++r) {
            for (int c = 0; c < matrix[r].length; ++c) {
                if (!Double.isNaN(matrix[r][c])) continue;
                matrix[r][c] = 0.0;
            }
        }
    }

    public static void cleanUpNaNs(float[][] matrix) {
        for (int r = 0; r < matrix.length; ++r) {
            for (int c = 0; c < matrix[r].length; ++c) {
                if (!Float.isNaN(matrix[r][c])) continue;
                matrix[r][c] = 0.0f;
            }
        }
    }

    public static double sum(double[][] data) {
        double sum = 0.0;
        double[][] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double val : row = dArray[i]) {
                sum += val;
            }
        }
        return sum;
    }

    public static double getAverage(RealMatrix data) {
        return MatrixTools.getAverage(data.getData());
    }

    public static double getAverage(double[][] data) {
        double average = 0.0;
        if (data.length > 0) {
            double total = 0.0;
            double[][] dArray = data;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] vals;
                for (double val : vals = dArray[i]) {
                    total += val;
                }
            }
            average = total / (double)data.length / (double)data[0].length;
        }
        return average;
    }

    public static void exportData(double[][] data, File file) {
        try {
            DecimalFormat df = new DecimalFormat("##.###");
            FileWriter fw = new FileWriter(file);
            double[][] dArray = data;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                double[] row;
                for (double val : row = dArray[i]) {
                    if (Double.isNaN(val)) {
                        fw.write("NaN, ");
                        continue;
                    }
                    fw.write(Double.valueOf(df.format(val)) + ", ");
                }
                fw.write("0\n");
            }
            fw.close();
        }
        catch (Exception e) {
            System.err.println("Error exporting matrix");
            e.printStackTrace();
            System.exit(86);
        }
    }

    public static double[][] transpose(double[][] matrix) {
        int h0 = matrix.length;
        int w0 = matrix[0].length;
        double[][] transposedMatrix = new double[w0][h0];
        for (int i = 0; i < h0; ++i) {
            for (int j = 0; j < w0; ++j) {
                transposedMatrix[j][i] = matrix[i][j];
            }
        }
        return transposedMatrix;
    }

    public static float[][] transpose(float[][] matrix) {
        int h0 = matrix.length;
        int w0 = matrix[0].length;
        float[][] transposedMatrix = new float[w0][h0];
        for (int i = 0; i < h0; ++i) {
            for (int j = 0; j < w0; ++j) {
                transposedMatrix[j][i] = matrix[i][j];
            }
        }
        return transposedMatrix;
    }

    public static double[][] convertToDoubleMatrix(boolean[][] adjacencyMatrix) {
        double[][] matrix = new double[adjacencyMatrix.length][adjacencyMatrix[0].length];
        for (int i = 0; i < adjacencyMatrix.length; ++i) {
            for (int j = 0; j < adjacencyMatrix[0].length; ++j) {
                if (!adjacencyMatrix[i][j]) continue;
                matrix[i][j] = 1.0;
            }
        }
        return matrix;
    }

    public static double[][] convertToDoubleMatrix(int[][] adjacencyMatrix) {
        double[][] matrix = new double[adjacencyMatrix.length][adjacencyMatrix[0].length];
        for (int i = 0; i < adjacencyMatrix.length; ++i) {
            for (int j = 0; j < adjacencyMatrix[0].length; ++j) {
                matrix[i][j] = adjacencyMatrix[i][j];
            }
        }
        return matrix;
    }

    public static float[][] convertToFloatMatrix(double[][] dataMatrix) {
        float[][] matrix = new float[dataMatrix.length][dataMatrix[0].length];
        for (int i = 0; i < dataMatrix.length; ++i) {
            for (int j = 0; j < dataMatrix[0].length; ++j) {
                matrix[i][j] = (float)dataMatrix[i][j];
            }
        }
        return matrix;
    }

    public static void copyFromAToBRegion(double[][] source, double[][] destination, int rowOffSet, int colOffSet) {
        for (int i = 0; i < source.length; ++i) {
            System.arraycopy(source[i], 0, destination[i + rowOffSet], colOffSet, source[0].length);
        }
    }

    public static void copyFromAToBRegion(float[][] source, float[][] destination, int rowOffSet, int colOffSet) {
        for (int i = 0; i < source.length; ++i) {
            System.arraycopy(source[i], 0, destination[i + rowOffSet], colOffSet, source[0].length);
        }
    }

    public static void saveMatrixTextV2(String filename, RealMatrix realMatrix) {
        MatrixTools.saveMatrixTextV2(filename, realMatrix.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMatrixTextV2(String filename, double[][] matrix) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            for (double[] row : matrix) {
                String s = Arrays.toString(row);
                s = s.replaceAll("\\[", "").replaceAll("\\]", "").trim();
                writer.write(s + "\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMatrixTextV2(String filename, float[][] matrix) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            for (float[] row : matrix) {
                String s = Arrays.toString(row);
                s = s.replaceAll("\\[", "").replaceAll("\\]", "").trim();
                writer.write(s + "\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveMatrixTextV2(String filename, int[][] matrix) {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), StandardCharsets.UTF_8));
            for (int[] row : matrix) {
                String s = Arrays.toString(row);
                s = s.replaceAll("\\[", "").replaceAll("\\]", "").trim();
                writer.write(s + "\n");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void saveMatrixTextNumpy(String filename, double[][] matrix) {
        int numRows = matrix.length;
        int numCols = matrix[0].length;
        double[] flattenedArray = MatrixTools.flattenedRowMajorOrderMatrix(matrix);
        NpyFile.write(Paths.get(filename, new String[0]), flattenedArray, new int[]{numRows, numCols});
    }

    public static void saveMatrixTextNumpy(String filename, float[][] matrix) {
        int numRows = matrix.length;
        int numCols = matrix[0].length;
        float[] flattenedArray = MatrixTools.flattenedRowMajorOrderMatrix(matrix);
        NpyFile.write(Paths.get(filename, new String[0]), flattenedArray, new int[]{numRows, numCols});
    }

    public static void saveMatrixTextNumpy(String filename, int[][] matrix) {
        int numRows = matrix.length;
        int numCols = matrix[0].length;
        int[] flattenedArray = MatrixTools.flattenedRowMajorOrderMatrix(matrix);
        NpyFile.write(Paths.get(filename, new String[0]), flattenedArray, new int[]{numRows, numCols});
    }

    public static void saveMatrixTextNumpy(String filename, int[] matrix) {
        NpyFile.write(Paths.get(filename, new String[0]), matrix, new int[]{1, matrix.length});
    }

    public static void saveMatrixTextNumpy(String filename, double[] matrix) {
        NpyFile.write(Paths.get(filename, new String[0]), matrix, new int[]{1, matrix.length});
    }

    public static void saveMatrixTextNumpy(String filename, float[] matrix) {
        NpyFile.write(Paths.get(filename, new String[0]), matrix, new int[]{1, matrix.length});
    }

    public static void saveMatrixTextNumpy(String filename, long[] matrix) {
        NpyFile.write(Paths.get(filename, new String[0]), matrix, new int[]{1, matrix.length});
    }

    public static float[][] generateCompositeMatrixWithNansCleaned(RealMatrix matrixDiag1, RealMatrix matrixDiag2, RealMatrix matrix1vs2) {
        return MatrixTools.generateCompositeMatrixWithNansCleaned(MatrixTools.convertToFloatMatrix(matrixDiag1.getData()), MatrixTools.convertToFloatMatrix(matrixDiag2.getData()), MatrixTools.convertToFloatMatrix(matrix1vs2.getData()));
    }

    public static float[][] generateCompositeMatrixWithNansCleaned(float[][] matrixDiag1, float[][] matrixDiag2, float[][] matrix1vs2) {
        int newLength = matrixDiag1.length + matrixDiag2.length;
        float[][] compositeMatrix = new float[newLength][newLength];
        MatrixTools.copyFromAToBRegion(matrixDiag1, compositeMatrix, 0, 0);
        MatrixTools.copyFromAToBRegion(matrixDiag2, compositeMatrix, matrixDiag1.length, matrixDiag1.length);
        for (int i = 0; i < matrix1vs2.length; ++i) {
            for (int j = 0; j < matrix1vs2[0].length; ++j) {
                compositeMatrix[i][matrixDiag1.length + j] = matrix1vs2[i][j];
                compositeMatrix[matrixDiag1.length + j][i] = matrix1vs2[i][j];
            }
        }
        MatrixTools.cleanUpNaNs(compositeMatrix);
        return compositeMatrix;
    }

    public static double[][] deepClone(double[][] data) {
        double[][] copy = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, copy[i], 0, data[i].length);
        }
        return copy;
    }

    public static float[][] deepClone(float[][] data) {
        float[][] copy = new float[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, copy[i], 0, data[i].length);
        }
        return copy;
    }

    public static void labelRegionWithOnes(int[][] labelsMatrix, int rowLength, int numRows, int colLength, int numCols, int startRowOf1, int startColOf1) {
        for (int i = 0; i < Math.min(rowLength, numRows); ++i) {
            for (int j = 0; j < Math.min(colLength, numCols); ++j) {
                labelsMatrix[startRowOf1 + i][startColOf1 + j] = 1;
            }
        }
    }

    public static void labelEnrichedRegionWithOnes(int[][] labelsMatrix, double[][] data, int rowLength, int numRows, int colLength, int numCols, int startRowOf1, int startColOf1) {
        double total = 0.0;
        int numVals = 0;
        for (int i = 0; i < Math.min(rowLength, numRows); ++i) {
            for (int j = 0; j < Math.min(colLength, numCols); ++j) {
                total += data[startRowOf1 + i][startColOf1 + j];
                ++numVals;
            }
        }
        double average = total / (double)numVals;
        for (int i = 0; i < Math.min(rowLength, numRows); ++i) {
            for (int j = 0; j < Math.min(colLength, numCols); ++j) {
                if (!(data[startRowOf1 + i][startColOf1 + j] > average)) continue;
                labelsMatrix[startRowOf1 + i][startColOf1 + j] = 1;
            }
        }
    }

    public static double[][] stitchMultipleMatricesTogetherByRowDim(List<double[][]> data) {
        int colNums = data.get(0)[0].length;
        int rowNums = 0;
        for (double[][] mtrx : data) {
            rowNums += mtrx.length;
        }
        double[][] aggregate = new double[rowNums][colNums];
        int rowOffSet = 0;
        for (double[][] region : data) {
            MatrixTools.copyFromAToBRegion(region, aggregate, rowOffSet, 0);
            rowOffSet += region.length;
        }
        return aggregate;
    }

    public static double[][] takeDerivativeDownColumn(double[][] data) {
        int i;
        double[][] derivative = new double[data.length][data[0].length - 1];
        for (i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, derivative[i], 0, derivative[i].length);
        }
        for (i = 0; i < derivative.length; ++i) {
            for (int j = 0; j < derivative[i].length; ++j) {
                double[] dArray = derivative[i];
                int n = j;
                dArray[n] = dArray[n] - data[i][j + 1];
            }
        }
        return derivative;
    }

    public static double[][] smoothAndAppendDerivativeDownColumn(double[][] data, double[] convolution) {
        int j;
        int i;
        int numColumns = data[0].length;
        if (convolution != null && convolution.length > 1) {
            numColumns -= convolution.length - 1;
        }
        double[][] appendedDerivative = new double[data.length][2 * numColumns - 1];
        if (convolution != null && convolution.length > 1) {
            for (i = 0; i < data.length; ++i) {
                for (j = 0; j < numColumns; ++j) {
                    for (int k = 0; k < convolution.length; ++k) {
                        double[] dArray = appendedDerivative[i];
                        int n = j;
                        dArray[n] = dArray[n] + convolution[k] * data[i][j + k];
                    }
                }
            }
        } else {
            for (i = 0; i < data.length; ++i) {
                System.arraycopy(data[i], 0, appendedDerivative[i], 0, numColumns);
            }
        }
        for (i = 0; i < data.length; ++i) {
            for (j = 0; j < numColumns - 1; ++j) {
                appendedDerivative[i][numColumns + j] = appendedDerivative[i][j] - appendedDerivative[i][j + 1];
            }
        }
        return appendedDerivative;
    }

    public static float[][] getNormalizedThresholdedAndAppendedDerivativeDownColumn(float[][] data, float maxVal, float scaleDerivFactor, float derivativeThreshold) {
        int i;
        double[] averageVal = new double[data.length];
        for (i = 0; i < data.length; ++i) {
            for (float val : data[i]) {
                int n = i;
                averageVal[n] = averageVal[n] + (double)val;
            }
        }
        for (i = 0; i < data.length; ++i) {
            averageVal[i] = averageVal[i] / (double)data[i].length;
        }
        float[][] thresholdedData = new float[data.length][data[0].length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            for (int j = 0; j < data[i2].length; ++j) {
                thresholdedData[i2][j] = (float)Math.min((double)maxVal, (double)data[i2][j] / averageVal[i2]);
            }
        }
        return MatrixTools.getMainAppendedDerivativeScaledPosDownColumn(thresholdedData, scaleDerivFactor, derivativeThreshold);
    }

    public static float[][] getNormalizedThresholdedByMedian(float[][] data, float maxVal) {
        double[] medianVal = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            medianVal[i] = MatrixTools.getMedian(data[i]);
        }
        float[][] thresholdedData = new float[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                thresholdedData[i][j] = (float)Math.min((double)maxVal, (double)data[i][j] / medianVal[i]);
            }
        }
        return thresholdedData;
    }

    public static double getMedian(float[] values2) {
        double[] array = new double[values2.length];
        for (int k = 0; k < values2.length; ++k) {
            array[k] = values2[k];
        }
        Median median = new Median();
        return median.evaluate(array);
    }

    public static float[][] getMainAppendedDerivativeScaledPosDownColumn(float[][] data, float scaleDerivFactor, float threshold) {
        int i;
        int numColumns = data[0].length;
        float[][] derivative = MatrixTools.getRelevantDerivativeScaledPositive(data, scaleDerivFactor, threshold);
        float[][] appendedDerivative = new float[data.length][numColumns + derivative[0].length];
        for (i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, appendedDerivative[i], 0, numColumns);
        }
        for (i = 0; i < data.length; ++i) {
            System.arraycopy(derivative[i], 0, appendedDerivative[i], numColumns, derivative[i].length);
        }
        return appendedDerivative;
    }

    public static float[][] getMainAppendedDerivativeDownColumnV2(float[][] data, float scaleDerivFactor, float threshold) {
        int i;
        int numColumns = data[0].length;
        float[][] derivative = MatrixTools.getRelevantDerivative(data, scaleDerivFactor, threshold);
        float[][] appendedDerivative = new float[data.length][numColumns + derivative[0].length];
        for (i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, appendedDerivative[i], 0, numColumns);
        }
        for (i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                appendedDerivative[i][j] = Math.min(0.5f, Math.max(-0.5f, appendedDerivative[i][j]));
            }
        }
        for (i = 0; i < data.length; ++i) {
            System.arraycopy(derivative[i], 0, appendedDerivative[i], numColumns, derivative[i].length);
        }
        return appendedDerivative;
    }

    public static float[][] getMainAppendedDerivativeDownColumn(float[][] data, float scaleDerivFactor, float threshold) {
        int i;
        int numColumns = data[0].length;
        float[][] derivative = MatrixTools.getRelevantDerivative(data, scaleDerivFactor, threshold);
        float[][] appendedDerivative = new float[data.length][numColumns + derivative[0].length];
        for (i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, appendedDerivative[i], 0, numColumns);
        }
        for (i = 0; i < data.length; ++i) {
            System.arraycopy(derivative[i], 0, appendedDerivative[i], numColumns, derivative[i].length);
        }
        return appendedDerivative;
    }

    public static float[][] getRelevantDerivativeScaledPositive(float[][] data, float scaleDerivFactor, float threshold) {
        float[][] derivative = new float[data.length][data[0].length - 1];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length - 1; ++j) {
                derivative[i][j] = data[i][j] - data[i][j + 1];
            }
        }
        float[] columnSums = MatrixTools.getAbsValColSums(derivative);
        ArrayList<Integer> indicesToUse = new ArrayList<Integer>();
        for (int k = 0; k < columnSums.length; ++k) {
            if (!(columnSums[k] > 0.0f)) continue;
            indicesToUse.add(k);
        }
        float[][] importantDerivative = new float[data.length][indicesToUse.size()];
        for (int i = 0; i < data.length; ++i) {
            for (int k = 0; k < indicesToUse.size(); ++k) {
                int indexToUse = (Integer)indicesToUse.get(k);
                importantDerivative[i][k] = Math.min(threshold, Math.max(-threshold, derivative[i][indexToUse] * scaleDerivFactor)) + threshold;
            }
        }
        return importantDerivative;
    }

    public static float[][] getRelevantDerivative(float[][] data, float scaleDerivFactor, float threshold) {
        float[][] derivative = new float[data.length][data[0].length - 1];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length - 1; ++j) {
                derivative[i][j] = data[i][j] - data[i][j + 1];
            }
        }
        float[] columnSums = MatrixTools.getAbsValColSums(derivative);
        ArrayList<Integer> indicesToUse = new ArrayList<Integer>();
        for (int k = 0; k < columnSums.length; ++k) {
            if (!(columnSums[k] > 0.0f)) continue;
            indicesToUse.add(k);
        }
        float[][] importantDerivative = new float[data.length][indicesToUse.size()];
        for (int i = 0; i < data.length; ++i) {
            for (int k = 0; k < indicesToUse.size(); ++k) {
                int indexToUse = (Integer)indicesToUse.get(k);
                importantDerivative[i][k] = Math.min(threshold, Math.max(-threshold, derivative[i][indexToUse] * scaleDerivFactor));
            }
        }
        return importantDerivative;
    }

    public static float[][] getRelevantDiscreteIntDerivativeScaledPositive(float[][] data, float scaleDerivFactor, float threshold) {
        int[][] derivative = new int[data.length][data[0].length - 1];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length - 1; ++j) {
                float tempVal = data[i][j] - data[i][j + 1];
                tempVal = Math.min(threshold, Math.max(-threshold, tempVal * scaleDerivFactor));
                derivative[i][j] = Math.round(tempVal);
            }
        }
        int[] columnSums = MatrixTools.getAbsValColSums(derivative);
        ArrayList<Integer> indicesToUse = new ArrayList<Integer>();
        for (int k = 0; k < columnSums.length; ++k) {
            if (columnSums[k] <= 0) continue;
            indicesToUse.add(k);
        }
        float[][] importantDerivative = new float[data.length][indicesToUse.size()];
        for (int i = 0; i < data.length; ++i) {
            for (int k = 0; k < indicesToUse.size(); ++k) {
                int indexToUse = (Integer)indicesToUse.get(k);
                importantDerivative[i][k] = (float)derivative[i][indexToUse] + threshold;
            }
        }
        return importantDerivative;
    }

    public static RealMatrix normedCopy(RealMatrix original, RealMatrix v1, RealMatrix v2, int n) {
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(n, n);
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                double normVal = v1.getEntry(r, 0) * v2.getEntry(c, 0);
                if (normVal > 0.0) {
                    matrix.setEntry(r, c, original.getEntry(r, c) / normVal);
                    continue;
                }
                matrix.setEntry(r, c, 0.0);
            }
        }
        return matrix;
    }

    public static float[][] normedCopyFloats(float[][] original, float[] v1, float[] v2, int n) {
        float[][] matrix = new float[n][n];
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                double normVal = v1[r] * v2[c];
                matrix[r][c] = normVal > 0.0 ? (float)((double)original[r][c] / normVal) : 0.0f;
            }
        }
        return matrix;
    }
}

