/*
 * Decompiled with CFR 0.152.
 */
package javastraw.tools;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javastraw.reader.Dataset;
import javastraw.reader.DatasetReaderV2;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.expected.ExpectedValueFunctionImpl;
import javastraw.reader.norm.NormalizationVector;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;

class HiCFileUtils {
    private final Dataset dataset;

    private HiCFileUtils(String hicfile, boolean useCache, boolean useDynamicBlockIndex) throws IOException {
        DatasetReaderV2 reader = new DatasetReaderV2(hicfile, useCache, useDynamicBlockIndex);
        this.dataset = reader.read();
    }

    public static void main(String[] args) throws IOException {
        HiCFileUtils utils = new HiCFileUtils(args[0], false, true);
        utils.dumpNormalizationVectors(NormalizationHandler.KR, "1", HiCZoom.HiCUnit.BP, 250000);
        utils.dumpExpectedVectors(NormalizationHandler.KR, HiCZoom.HiCUnit.BP, 1000000);
    }

    private void dumpNormalizationVectors(NormalizationType normType, String chrName, HiCZoom.HiCUnit unit, int binSize) {
        Chromosome chromosome = this.findChromosome(chrName);
        HiCZoom zoom = new HiCZoom(unit, binSize);
        NormalizationVector nv = this.dataset.getNormalizationVector(chromosome.getIndex(), zoom, normType);
        String label = "Normalization vector: type = " + normType.getLabel() + " chr = " + chrName + " resolution = " + binSize + " " + (Object)((Object)unit);
        System.out.println(label);
        for (double[] array : nv.getData().getValues()) {
            for (double datum : array) {
                System.out.println(datum);
            }
        }
    }

    private void dumpExpectedVectors(NormalizationType normType, HiCZoom.HiCUnit unit, int binSize) {
        Map<String, ExpectedValueFunction> expValFunMap = this.dataset.getExpectedValueFunctionMap();
        for (Map.Entry<String, ExpectedValueFunction> entry : expValFunMap.entrySet()) {
            ExpectedValueFunctionImpl ev = (ExpectedValueFunctionImpl)entry.getValue();
            if (!ev.getUnit().equals((Object)unit) || ev.getBinSize() != binSize || !ev.getNormalizationType().equals(normType)) continue;
            String label = ev.getNormalizationType() + "\t" + (Object)((Object)ev.getUnit()) + "\t" + ev.getBinSize();
            System.out.println("Norm factors: " + label);
            for (Map.Entry<Integer, Double> nf : ev.getNormFactors().entrySet()) {
                System.out.println(nf.getKey() + "\t" + nf.getValue());
            }
            System.out.println("Expected values: " + label);
            Iterator<Map.Entry<Integer, Double>> iterator2 = ev.getExpectedValuesNoNormalization().getValues().iterator();
            while (iterator2.hasNext()) {
                double[] values2;
                for (double datum : values2 = (double[])iterator2.next()) {
                    System.out.println(datum);
                }
            }
            System.out.println("End expected values: " + label);
            System.out.println();
        }
    }

    private Chromosome findChromosome(String name) {
        for (Chromosome chr : this.dataset.getChromosomeHandler().getChromosomeArray()) {
            if (!chr.getName().equalsIgnoreCase(name)) continue;
            return chr;
        }
        return null;
    }
}

