/*
 * Decompiled with CFR 0.152.
 */
package javastraw.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javastraw.reader.Dataset;
import javastraw.reader.DatasetReader;
import javastraw.reader.DatasetReaderFactory;
import javastraw.reader.DatasetReaderV2;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeHandler;
import javastraw.reader.block.Block;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.ExtractingOEDataUtils;
import javastraw.tools.MatrixTools;
import org.apache.commons.math3.linear.RealMatrix;
import org.jetbrains.annotations.NotNull;

public class HiCFileTools {
    public static Dataset extractDatasetForCLT(String filename, boolean allowPrinting, boolean useCache, boolean useDynamicBlockIndex) {
        Dataset dataset = null;
        String file = filename;
        if (HiCFileTools.isDropboxURL(file)) {
            file = HiCFileTools.cleanUpDropboxURL(file);
        }
        try {
            DatasetReaderV2 reader = new DatasetReaderV2(file, useCache, useDynamicBlockIndex);
            dataset = reader.read();
            HiCFileTools.verifySupportedHiCFileVersion(reader.getVersion());
        }
        catch (Exception e) {
            System.err.println("Could not read hic file (" + file + "): " + e.getLocalizedMessage());
            System.exit(34);
        }
        return dataset;
    }

    @NotNull
    private static DatasetReader getDatasetVerifyMagicString(boolean allowPrinting, boolean useCache, String file, DatasetReader reader, boolean useDynamicBlockIndex) throws IOException {
        String magicString;
        if (allowPrinting) {
            System.out.println("Reading file: " + file);
        }
        if ((magicString = DatasetReaderFactory.getMagicString(file)).equals("HIC")) {
            reader = new DatasetReaderV2(file, useCache, useDynamicBlockIndex);
        } else {
            System.err.println("This version of HIC is no longer supported");
            System.exit(32);
        }
        DatasetReader datasetReader = reader;
        if (datasetReader == null) {
            HiCFileTools.$$$reportNull$$$0(0);
        }
        return datasetReader;
    }

    private static void verifySupportedHiCFileVersion(int version) throws RuntimeException {
        if (version < 6) {
            throw new RuntimeException("This file is version " + version + ". Only versions " + 6 + " and greater are supported at this time.");
        }
    }

    public static DatasetReader extractDatasetReaderForCLT(List<String> files, boolean allowPrinting, boolean useCache, boolean useDynamicBlockIndex) {
        DatasetReader reader = null;
        String file = files.get(0);
        if (HiCFileTools.isDropboxURL(file)) {
            file = HiCFileTools.cleanUpDropboxURL(file);
        }
        try {
            reader = HiCFileTools.getDatasetVerifyMagicString(allowPrinting, useCache, file, reader, useDynamicBlockIndex);
        }
        catch (Exception e) {
            System.err.println("Could not read hic file (" + file + "): " + e.getLocalizedMessage());
            System.exit(34);
        }
        return reader;
    }

    public static List<Integer> filterResolutions(List<HiCZoom> availableZooms, int[] resolutions) {
        TreeSet<Integer> resSet = new TreeSet<Integer>();
        for (HiCZoom zoom : availableZooms) {
            resSet.add(zoom.getBinSize());
        }
        ArrayList<Integer> finalResolutions = new ArrayList<Integer>();
        for (int res : resolutions) {
            finalResolutions.add(HiCFileTools.closestValue(res, resSet));
        }
        return finalResolutions;
    }

    private static int closestValue(int val, TreeSet<Integer> valSet) {
        int ceilVal;
        int floorVal;
        try {
            floorVal = valSet.floor(val);
        }
        catch (Exception e) {
            return valSet.ceiling(val);
        }
        try {
            ceilVal = valSet.ceiling(val);
        }
        catch (Exception e) {
            return floorVal;
        }
        if (Math.abs(ceilVal - val) < Math.abs(val - floorVal)) {
            return ceilVal;
        }
        return floorVal;
    }

    public static ChromosomeHandler getChromosomeSetIntersection(ChromosomeHandler handler1, ChromosomeHandler handler2) {
        return handler1.getIntersectionWith(handler2);
    }

    public static Set<HiCZoom> getZoomSetIntersection(Collection<HiCZoom> collection1, Collection<HiCZoom> collection2) {
        HashSet<HiCZoom> set1 = new HashSet<HiCZoom>(collection1);
        HashSet<HiCZoom> set2 = new HashSet<HiCZoom>(collection2);
        boolean set1IsLarger = set1.size() > set2.size();
        HashSet<HiCZoom> cloneSet = new HashSet<HiCZoom>(set1IsLarger ? set2 : set1);
        cloneSet.retainAll(set1IsLarger ? set1 : set2);
        return cloneSet;
    }

    public static ChromosomeHandler stringToChromosomes(List<String> chromosomesSpecified, ChromosomeHandler handler) {
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
        chromosomes.add(0, null);
        for (String strKey : chromosomesSpecified) {
            boolean chrFound = false;
            for (Chromosome chrKey : handler.getChromosomeArray()) {
                if (!HiCFileTools.equivalentChromosome(strKey, chrKey)) continue;
                chromosomes.add(chrKey);
                chrFound = true;
                break;
            }
            if (chrFound) continue;
            System.err.println("Chromosome " + strKey + " not found");
        }
        return new ChromosomeHandler(chromosomes, handler.getGenomeID(), true);
    }

    public static boolean equivalentChromosome(String token, Chromosome chr) {
        String token2 = token.toLowerCase().replaceAll("chr", "");
        String chrName = chr.getName().toLowerCase().replaceAll("chr", "");
        return token2.equals(chrName);
    }

    public static PrintWriter openWriter(File file) {
        try {
            file.createNewFile();
            file.setWritable(true);
            return new PrintWriter((Writer)new BufferedWriter(new FileWriter(file)), true);
        }
        catch (IOException e) {
            System.out.println("I/O error opening file.");
            System.exit(37);
            return null;
        }
    }

    public static RealMatrix extractLocalBoundedRegion(MatrixZoomData zd, int limStart, int limEnd, int n, NormalizationType normalizationType, boolean fillUnderDiagonal) throws IOException {
        return HiCFileTools.extractLocalBoundedRegion(zd, limStart, limEnd, limStart, limEnd, n, n, normalizationType, fillUnderDiagonal);
    }

    public static RealMatrix extractLocalBoundedRegion(MatrixZoomData zd, int binXStart, int binYStart, int numRows, int numCols, NormalizationType normalizationType, boolean fillUnderDiagonal) throws IOException {
        return HiCFileTools.extractLocalBoundedRegion(zd, binXStart, binXStart + numRows, binYStart, binYStart + numCols, numRows, numCols, normalizationType, fillUnderDiagonal);
    }

    public static RealMatrix extractLocalBoundedRegion(MatrixZoomData zd, long binXStart, long binXEnd, long binYStart, long binYEnd, int numRows, int numCols, NormalizationType normalizationType, boolean fillUnderDiagonal) throws IOException {
        List<Block> blocks = HiCFileTools.getAllRegionBlocks(zd, binXStart, binXEnd, binYStart, binYEnd, normalizationType, fillUnderDiagonal);
        RealMatrix data = MatrixTools.cleanArray2DMatrix(numRows, numCols);
        if (blocks.size() > 0) {
            for (Block b : blocks) {
                if (b == null) continue;
                for (ContactRecord rec : b.getContactRecords()) {
                    int relativeX = (int)((long)rec.getBinX() - binXStart);
                    int relativeY = (int)((long)rec.getBinY() - binYStart);
                    if (relativeX >= 0 && relativeX < numRows && relativeY >= 0 && relativeY < numCols) {
                        data.addToEntry(relativeX, relativeY, rec.getCounts());
                    }
                    if (!fillUnderDiagonal) continue;
                    relativeX = (int)((long)rec.getBinY() - binXStart);
                    relativeY = (int)((long)rec.getBinX() - binYStart);
                    if (relativeX < 0 || relativeX >= numRows || relativeY < 0 || relativeY >= numCols) continue;
                    data.addToEntry(relativeX, relativeY, rec.getCounts());
                }
            }
        }
        blocks = null;
        return data;
    }

    public static float[][] extractLocalBoundedRegionFloatMatrix(MatrixZoomData zd, int binXStart, int binXEnd, int binYStart, int binYEnd, int numRows, int numCols, NormalizationType normalizationType, boolean fillUnderDiagonal) throws IOException {
        List<Block> blocks = HiCFileTools.getAllRegionBlocks(zd, binXStart, binXEnd, binYStart, binYEnd, normalizationType, fillUnderDiagonal);
        float[][] data = new float[numRows][numCols];
        if (blocks.size() > 0) {
            for (Block b : blocks) {
                if (b == null) continue;
                for (ContactRecord rec : b.getContactRecords()) {
                    HiCFileTools.fillInMatrixWithRecords(binXStart, binYStart, numRows, numCols, fillUnderDiagonal, data, rec);
                }
            }
        }
        blocks = null;
        return data;
    }

    public static void fillInMatrixWithRecords(int binXStart, int binYStart, int numRows, int numCols, boolean fillUnderDiagonal, float[][] data, ContactRecord rec) {
        int relativeX = rec.getBinX() - binXStart;
        int relativeY = rec.getBinY() - binYStart;
        if (relativeX >= 0 && relativeX < numRows && relativeY >= 0 && relativeY < numCols) {
            data[relativeX][relativeY] = rec.getCounts();
        }
        if (fillUnderDiagonal) {
            relativeX = rec.getBinY() - binXStart;
            relativeY = rec.getBinX() - binYStart;
            if (relativeX >= 0 && relativeX < numRows && relativeY >= 0 && relativeY < numCols) {
                data[relativeX][relativeY] = rec.getCounts();
            }
        }
    }

    public static RealMatrix extractLocalRowSums(MatrixZoomData zd, long binXStart, long binXEnd, long chrStart, long chrEnd, int numRows, NormalizationType normalizationType, boolean fillUnderDiagonal) throws IOException {
        List<Block> blocks = HiCFileTools.getAllRegionBlocks(zd, binXStart, binXEnd, chrStart, chrEnd, normalizationType, fillUnderDiagonal);
        RealMatrix data = MatrixTools.cleanArray2DMatrix(numRows, 1);
        if (blocks.size() > 0) {
            for (Block b : blocks) {
                if (b == null) continue;
                for (ContactRecord rec : b.getContactRecords()) {
                    int relativeX = (int)((long)rec.getBinX() - binXStart);
                    int relativeY = (int)((long)rec.getBinY() - binXStart);
                    if (!(rec.getCounts() > 0.0f)) continue;
                    if (relativeX >= 0 && relativeX < numRows) {
                        data.addToEntry(relativeX, 0, rec.getCounts());
                        continue;
                    }
                    if (relativeY < 0 || relativeY >= numRows) continue;
                    data.addToEntry(relativeY, 0, rec.getCounts());
                }
            }
        }
        blocks = null;
        return data;
    }

    public static float[] extractLocalRowSumsFloatArray(MatrixZoomData zd, long binXStart, long binXEnd, long chrStart, long chrEnd, int numRows, NormalizationType normalizationType, boolean fillUnderDiagonal) throws IOException {
        List<Block> blocks = HiCFileTools.getAllRegionBlocks(zd, binXStart, binXEnd, chrStart, chrEnd, normalizationType, fillUnderDiagonal);
        float[] data = new float[numRows];
        if (blocks.size() > 0) {
            for (Block b : blocks) {
                if (b == null) continue;
                for (ContactRecord rec : b.getContactRecords()) {
                    int relativeX = (int)((long)rec.getBinX() - binXStart);
                    int relativeY = (int)((long)rec.getBinY() - binXStart);
                    if (!(rec.getCounts() > 0.0f)) continue;
                    if (relativeX >= 0 && relativeX < numRows) {
                        int n = relativeX;
                        data[n] = data[n] + rec.getCounts();
                        continue;
                    }
                    if (relativeY < 0 || relativeY >= numRows) continue;
                    int n = relativeY;
                    data[n] = data[n] + rec.getCounts();
                }
            }
        }
        blocks.clear();
        blocks = null;
        return data;
    }

    public static List<Block> getAllRegionBlocks(MatrixZoomData zd, long binXStart, long binXEnd, long binYStart, long binYEnd, NormalizationType normalizationType, boolean fillUnderDiagonal) throws IOException {
        List<Block> blocks = Collections.synchronizedList(new ArrayList());
        try {
            blocks.addAll(zd.getNormalizedBlocksOverlapping(binXStart, binYStart, binXEnd, binYEnd, normalizationType, fillUnderDiagonal));
        }
        catch (Exception e) {
            HiCFileTools.triggerNormError(normalizationType);
            System.err.println("You do not have " + normalizationType + " normalized maps available for this resolution/region:");
            System.err.println("x1 " + binXStart + " x2 " + binXEnd + " y1 " + binYStart + " y2 " + binYEnd + " res " + zd.getBinSize());
            System.err.println("Map is likely too sparse or a different normalization/resolution should be chosen.");
            e.printStackTrace();
            System.exit(38);
        }
        return blocks;
    }

    public static RealMatrix extractLocalBoundedExpectedRegion(ExpectedValueFunction df, Chromosome chr, int binXStart, int binYStart, int numRows, int numCols) {
        RealMatrix data = MatrixTools.cleanArray2DMatrix(numRows, numCols);
        for (int relativeX = 0; relativeX < numRows; ++relativeX) {
            for (int relativeY = 0; relativeY < numRows; ++relativeY) {
                int dist = Math.abs(binXStart - binYStart + (relativeX - relativeY));
                double expected = df.getExpectedValue(chr.getIndex(), dist);
                data.addToEntry(relativeX, relativeY, expected);
            }
        }
        return data;
    }

    public static float[][] extractLocalBoundedExpectedRegionFloatMatrix(ExpectedValueFunction df, Chromosome chr, int binXStart, int binYStart, int numRows, int numCols) {
        float[][] data = new float[numRows][numCols];
        for (int relativeX = 0; relativeX < numRows; ++relativeX) {
            int relativeY = 0;
            while (relativeY < numRows) {
                int dist = Math.abs(binXStart - binYStart + (relativeX - relativeY));
                double expected = df.getExpectedValue(chr.getIndex(), dist);
                float[] fArray = data[relativeX];
                int n = relativeY++;
                fArray[n] = (float)((double)fArray[n] + expected);
            }
        }
        return data;
    }

    public static ListOfDoubleArrays extractChromosomeExpectedVector(Dataset ds, int index, HiCZoom zoom, NormalizationType normalization, boolean getCorrectedVersion) {
        ExpectedValueFunction expectedValueFunction = ds.getExpectedValues(zoom, normalization, getCorrectedVersion);
        long n = expectedValueFunction.getLength();
        ListOfDoubleArrays expectedVector = new ListOfDoubleArrays(n);
        for (long i = 0L; i < n; ++i) {
            expectedVector.set(i, expectedValueFunction.getExpectedValue(index, i));
        }
        return expectedVector;
    }

    public static void triggerNormError(NormalizationType normalizationType) throws IOException {
        System.err.println();
        System.err.println("You do not have " + normalizationType + " normalized maps available for this resolution/region.");
        System.err.println("Region is likely too sparse/does not exist, or a different normalization/resolution should be chosen.");
        throw new IOException("Norm could not be found");
    }

    public static File createValidDirectory(String directoryPath) {
        File outputDirectory = new File(directoryPath);
        if (!(outputDirectory.exists() && outputDirectory.isDirectory() || outputDirectory.mkdir())) {
            System.err.println("Couldn't create output directory " + directoryPath);
            System.exit(40);
        }
        return outputDirectory;
    }

    public static String getTruncatedText(String text, int maxLengthEntryName) {
        String truncatedName = text;
        if (truncatedName.length() > maxLengthEntryName) {
            truncatedName = text.substring(0, maxLengthEntryName / 2 - 1);
            truncatedName = truncatedName + "...";
            truncatedName = truncatedName + text.substring(text.length() - maxLengthEntryName / 2);
        }
        return truncatedName;
    }

    public static boolean isDropboxURL(String url) {
        return url.contains("dropbox.com");
    }

    public static String cleanUpDropboxURL(String url) {
        return url.replace("?dl=0", "").replace("://www.dropbox.com", "://dl.dropboxusercontent.com");
    }

    public static MatrixZoomData getMatrixZoomData(Dataset ds, Chromosome chrom1, Chromosome chrom2, HiCZoom zoom) {
        Matrix matrix = ds.getMatrix(chrom1, chrom2);
        if (matrix == null || zoom == null) {
            return null;
        }
        return matrix.getZoomData(zoom);
    }

    public static MatrixZoomData getMatrixZoomData(Dataset ds, Chromosome chrom1, Chromosome chrom2, int resolution) {
        return HiCFileTools.getMatrixZoomData(ds, chrom1, chrom2, ds.getZoomForBPResolution(resolution));
    }

    public static float[][] getOEMatrixForChromosome(Dataset ds, Chromosome chromosome, int resolution, NormalizationType norm, double logThreshold, ExtractingOEDataUtils.ThresholdType thresholdType, boolean isIntra, boolean fillUnderDiagonal, float pseudocount, float invalidReplacement, boolean getCorrectedVersion) throws IOException {
        MatrixZoomData zd = HiCFileTools.getMatrixZoomData(ds, chromosome, chromosome, resolution);
        if (zd == null) {
            return null;
        }
        return HiCFileTools.getOEMatrixForChromosome(ds, zd, chromosome, resolution, norm, logThreshold, thresholdType, isIntra, fillUnderDiagonal, pseudocount, invalidReplacement, getCorrectedVersion);
    }

    public static float[][] getOEMatrixForChromosome(Dataset ds, MatrixZoomData zd, Chromosome chromosome, int resolution, NormalizationType norm, double logThreshold, ExtractingOEDataUtils.ThresholdType thresholdType, boolean isIntra, boolean fillUnderDiagonal, float pseudocount, float invalidReplacement, boolean getCorrectedVersion) throws IOException {
        ExpectedValueFunction df = ds.getExpectedValuesOrExit(zd.getZoom(), norm, true, getCorrectedVersion);
        int maxBin = (int)(chromosome.getLength() / (long)resolution + 1L);
        return ExtractingOEDataUtils.extractObsOverExpBoundedRegion(zd, 0, maxBin, 0, maxBin, maxBin, maxBin, norm, df, chromosome.getIndex(), logThreshold, isIntra, fillUnderDiagonal, thresholdType, pseudocount, invalidReplacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "javastraw/tools/HiCFileTools", "getDatasetVerifyMagicString"));
    }
}

