/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.type;

import java.util.ArrayList;
import java.util.List;
import javastraw.reader.type.NormalizationType;

public class NormalizationHandler {
    public static final String strNONE = "NONE";
    public static final String strVC = "VC";
    public static final String strVC_SQRT = "VC_SQRT";
    public static final String strKR = "KR";
    public static final String strGW_KR = "GW_KR";
    public static final String strINTER_KR = "INTER_KR";
    public static final String strGW_VC = "GW_VC";
    public static final String strINTER_VC = "INTER_VC";
    public static final String strSCALE = "SCALE";
    public static final String strGW_SCALE = "GW_SCALE";
    public static final String strINTER_SCALE = "INTER_SCALE";
    public static final NormalizationType NONE = new NormalizationType("NONE", "None");
    public static final NormalizationType VC = new NormalizationType("VC", "Coverage");
    public static final NormalizationType VC_SQRT = new NormalizationType("VC_SQRT", "Coverage (Sqrt)");
    public static final NormalizationType KR = new NormalizationType("KR", "Balanced");
    public static final NormalizationType GW_KR = new NormalizationType("GW_KR", "Genome-wide balanced");
    public static final NormalizationType INTER_KR = new NormalizationType("INTER_KR", "Inter balanced");
    public static final NormalizationType GW_VC = new NormalizationType("GW_VC", "Genome-wide coverage");
    public static final NormalizationType INTER_VC = new NormalizationType("INTER_VC", "Inter coverage");
    public static final NormalizationType SCALE = new NormalizationType("SCALE", "Balanced++");
    public static final NormalizationType GW_SCALE = new NormalizationType("GW_SCALE", "Genome-wide Balanced++");
    public static final NormalizationType INTER_SCALE = new NormalizationType("INTER_SCALE", "Inter Balanced++");
    private static final List<NormalizationType> currentlyAvailableNorms = new ArrayList<NormalizationType>();

    public NormalizationHandler() {
        currentlyAvailableNorms.add(NONE);
        currentlyAvailableNorms.add(KR);
        currentlyAvailableNorms.add(VC);
        currentlyAvailableNorms.add(VC_SQRT);
        currentlyAvailableNorms.add(GW_KR);
        currentlyAvailableNorms.add(GW_VC);
        currentlyAvailableNorms.add(INTER_KR);
        currentlyAvailableNorms.add(INTER_VC);
        currentlyAvailableNorms.add(SCALE);
        currentlyAvailableNorms.add(GW_SCALE);
        currentlyAvailableNorms.add(INTER_SCALE);
    }

    public static List<NormalizationType> getAllNormTypes() {
        return currentlyAvailableNorms;
    }

    public static boolean isGenomeWideNorm(NormalizationType norm) {
        return NormalizationHandler.isGenomeWideNormIntra(norm) || NormalizationHandler.isGenomeWideNormInter(norm);
    }

    public static NormalizationType[] getAllGWNormTypes(boolean isUseOnlyScalingDefaults) {
        if (isUseOnlyScalingDefaults) {
            return new NormalizationType[]{GW_SCALE};
        }
        return new NormalizationType[]{GW_KR, GW_VC, GW_SCALE, INTER_KR, INTER_VC, INTER_SCALE};
    }

    public static boolean isGenomeWideNormIntra(NormalizationType norm) {
        return norm.equals(GW_KR) || norm.equals(GW_VC) || norm.equals(GW_SCALE);
    }

    public static boolean isGenomeWideNormInter(NormalizationType norm) {
        return norm.equals(INTER_KR) || norm.equals(INTER_VC) || norm.equals(INTER_SCALE);
    }

    public static Integer getIdealResolutionLimit(NormalizationType normalizationType) {
        if (NormalizationHandler.isGenomeWideNorm(normalizationType)) {
            return 25000;
        }
        return 0;
    }

    public NormalizationType getNormTypeFromString(String text) {
        if (text != null && text.length() > 0) {
            for (NormalizationType norm : currentlyAvailableNorms) {
                if (!text.equalsIgnoreCase(norm.getLabel()) && !text.equalsIgnoreCase(norm.getDescription())) continue;
                return norm;
            }
        }
        NormalizationType newNormType = new NormalizationType(text, text);
        currentlyAvailableNorms.add(newNormType);
        return newNormType;
    }

    public List<NormalizationType> getDefaultSetForHiCFileBuilding() {
        ArrayList<NormalizationType> normalizationTypes = new ArrayList<NormalizationType>();
        normalizationTypes.add(VC);
        normalizationTypes.add(VC_SQRT);
        normalizationTypes.add(SCALE);
        normalizationTypes.add(INTER_SCALE);
        normalizationTypes.add(GW_SCALE);
        return normalizationTypes;
    }
}

