/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.type;

import java.util.Objects;

public class HiCZoom
implements Comparable<HiCZoom> {
    private final HiCUnit unit;
    private final Integer binSize;

    public HiCZoom(HiCUnit unit, int binSize) {
        this.unit = unit;
        this.binSize = binSize;
    }

    public HiCZoom(int binSize) {
        this.unit = HiCUnit.BP;
        this.binSize = binSize;
    }

    public HiCZoom clone() {
        return new HiCZoom(this.unit, this.binSize);
    }

    public static HiCUnit valueOfUnit(String unit) {
        if (unit.equalsIgnoreCase(HiCUnit.BP.toString())) {
            return HiCUnit.BP;
        }
        if (unit.equalsIgnoreCase(HiCUnit.FRAG.toString())) {
            return HiCUnit.FRAG;
        }
        return null;
    }

    public int getBinSize() {
        return this.binSize;
    }

    public String getKey() {
        return this.unit.toString() + "_" + this.binSize;
    }

    public String toString() {
        return this.getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HiCZoom) {
            HiCZoom hiCZoom = (HiCZoom)o;
            return this.binSize.equals(hiCZoom.binSize) && this.unit == hiCZoom.unit;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.unit.hashCode(), this.binSize);
    }

    @Override
    public int compareTo(HiCZoom o) {
        return this.binSize.compareTo(o.binSize);
    }

    public HiCUnit getUnit() {
        return this.unit;
    }

    public static enum HiCUnit {
        BP,
        FRAG;

    }
}

