/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.pearsons;

import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.matrices.BasicMatrix;
import javastraw.matrices.InMemoryMatrix;
import javastraw.reader.pearsons.PearsonCorrelationMetric;
import javastraw.tools.ParallelizationTools;

public class PearsonsUtils {
    private static double getVectorMean(double[] vector) {
        double sum = 0.0;
        int count = 0;
        for (double aVector : vector) {
            if (Double.isNaN(aVector)) continue;
            sum += aVector;
            ++count;
        }
        return count == 0 ? 0.0 : sum / (double)count;
    }

    public static BasicMatrix computeParallelizedPearsons(double[][] matrix, int dim, BitSet bitSet) {
        PearsonsUtils.inPlaceParallelSubtractRowMeans(matrix, dim, bitSet);
        InMemoryMatrix pearsons = new InMemoryMatrix(dim);
        AtomicInteger dCounter = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(() -> {
            int i = dCounter.getAndIncrement();
            while (i < dim) {
                if (bitSet.get(i)) {
                    for (int j = i + 1; j < dim; ++j) {
                        float corr = bitSet.get(j) ? (float)PearsonCorrelationMetric.corr(matrix[i], matrix[j]) : Float.NaN;
                        BasicMatrix basicMatrix = pearsons;
                        synchronized (basicMatrix) {
                            pearsons.setEntry(i, j, corr);
                            pearsons.setEntry(j, i, corr);
                            continue;
                        }
                    }
                } else {
                    BasicMatrix basicMatrix = pearsons;
                    synchronized (basicMatrix) {
                        for (int j = i + 1; j < dim; ++j) {
                            pearsons.setEntry(i, j, Float.NaN);
                            pearsons.setEntry(j, i, Float.NaN);
                        }
                    }
                }
                i = dCounter.getAndIncrement();
            }
        });
        for (int i = 0; i < dim; ++i) {
            if (bitSet.get(i)) {
                pearsons.setEntry(i, i, 1.0f);
                continue;
            }
            pearsons.setEntry(i, i, Float.NaN);
        }
        return pearsons;
    }

    private static void inPlaceParallelSubtractRowMeans(double[][] matrix, int dim, BitSet bitSet) {
        double[] rowMeans = new double[dim];
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(() -> {
            int i = index.getAndIncrement();
            while (i < dim) {
                if (bitSet.get(i)) {
                    rowMeans[i] = PearsonsUtils.getVectorMean(matrix[i]);
                }
                i = index.getAndIncrement();
            }
        });
        AtomicInteger index2 = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(() -> {
            int i = index2.getAndIncrement();
            while (i < dim) {
                if (bitSet.get(i)) {
                    for (int j = 0; j < dim; ++j) {
                        double[] dArray = matrix[i];
                        int n = j;
                        dArray[n] = dArray[n] - rowMeans[j];
                    }
                }
                i = index2.getAndIncrement();
            }
        });
    }
}

