/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.pearsons;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import javastraw.matrices.BasicMatrix;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.pearsons.PearsonsUtils;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class PearsonsManager {
    public static double[] computeEigenvector(BasicMatrix pearsons, int which) {
        int dim = pearsons.getRowDimension();
        BitSet bitSet = new BitSet(dim);
        for (int i = 0; i < dim; ++i) {
            float tmp = pearsons.getEntry(i, i);
            if (!((double)tmp > 0.999)) continue;
            bitSet.set(i);
        }
        int[] newPosToOrig = PearsonsManager.getMapNewPosToOriginal(dim, bitSet);
        RealMatrix subMatrix = PearsonsManager.getSubsetOfMatrix(newPosToOrig, bitSet.cardinality(), pearsons);
        RealVector rv = new EigenDecomposition(subMatrix).getEigenvector(which);
        double[] ev = rv.toArray();
        int size = pearsons.getColumnDimension();
        double[] eigenvector = new double[size];
        Arrays.fill(eigenvector, Double.NaN);
        for (int i = 0; i < newPosToOrig.length; ++i) {
            int oldI = newPosToOrig[i];
            eigenvector[oldI] = ev[i];
        }
        return eigenvector;
    }

    private static int[] getMapNewPosToOriginal(int dim, BitSet bitSet) {
        int[] newPosToOrig = new int[bitSet.cardinality()];
        int count = 0;
        for (int i = 0; i < dim; ++i) {
            if (!bitSet.get(i)) continue;
            newPosToOrig[count++] = i;
        }
        return newPosToOrig;
    }

    private static RealMatrix getSubsetOfMatrix(int[] newPosToOrig, int subsetN, BasicMatrix pearsons) {
        double[][] data = new double[subsetN][subsetN];
        for (int newI = 0; newI < newPosToOrig.length; ++newI) {
            int oldI = newPosToOrig[newI];
            for (int newJ = newI; newJ < newPosToOrig.length; ++newJ) {
                int oldJ = newPosToOrig[newJ];
                float tmp = pearsons.getEntry(oldI, oldJ);
                data[newI][newJ] = tmp;
                data[newJ][newI] = tmp;
            }
        }
        return new Array2DRowRealMatrix(data);
    }

    public static BasicMatrix computePearsons(ExpectedValueFunction df, Iterator<ContactRecord> iterator2, Chromosome chr1, int binSize) {
        int dim = (int)(chr1.getLength() / (long)binSize) + 1;
        double[][] oeMatrix = new double[dim][dim];
        BitSet bitSet = new BitSet(dim);
        PearsonsManager.populateOEMatrixAndBitset(oeMatrix, bitSet, df, iterator2, chr1.getIndex());
        return PearsonsUtils.computeParallelizedPearsons(oeMatrix, dim, bitSet);
    }

    private static void populateOEMatrixAndBitset(double[][] oeMatrix, BitSet bitSet, ExpectedValueFunction df, Iterator<ContactRecord> iterator2, int chr1Index) {
        while (iterator2.hasNext()) {
            double oeValue;
            ContactRecord record = iterator2.next();
            float counts = record.getCounts();
            if (Float.isNaN(counts)) continue;
            int i = record.getBinX();
            int j = record.getBinY();
            int dist = Math.abs(i - j);
            double expected = df.getExpectedValue(chr1Index, dist);
            oeMatrix[i][j] = oeValue = (double)counts / expected;
            oeMatrix[j][i] = oeValue;
            bitSet.set(i);
            bitSet.set(j);
        }
    }
}

