/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.norm;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javastraw.reader.ReaderTools;

public class NormFactorMapReader {
    private final int version;
    private final int nFactors;
    private final Map<Integer, Double> normFactors = new LinkedHashMap<Integer, Double>();

    public NormFactorMapReader(int nFactors, int version, long position, String path) throws IOException {
        this.version = version;
        this.nFactors = nFactors;
        SeekableStream stream = ReaderTools.getValidStream(path, position);
        LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(stream, this.getOffset()));
        for (int j = 0; j < nFactors; ++j) {
            int chrIdx = dis.readInt();
            if (version > 8) {
                this.normFactors.put(chrIdx, Double.valueOf(dis.readFloat()));
                continue;
            }
            this.normFactors.put(chrIdx, dis.readDouble());
        }
    }

    public Map<Integer, Double> getNormFactors() {
        return this.normFactors;
    }

    public int getOffset() {
        if (this.version > 8) {
            return 8 * this.nFactors;
        }
        return 12 * this.nFactors;
    }
}

