/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.mzd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javastraw.matrices.BasicMatrix;
import javastraw.reader.DatasetReader;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.Block;
import javastraw.reader.block.BlockIndices;
import javastraw.reader.block.BlockModifier;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.block.IdentityModifier;
import javastraw.reader.depth.LogDepth;
import javastraw.reader.depth.V9Depth;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.iterators.ContactRecordIterator;
import javastraw.reader.mzd.BlockCache;
import javastraw.reader.mzd.DynamicMatrixZoomData;
import javastraw.reader.mzd.LegacyVersionBlockReader;
import javastraw.reader.mzd.V9IntraBlockReader;
import javastraw.reader.pearsons.PearsonsManager;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationHandler;
import javastraw.reader.type.NormalizationType;

public class MatrixZoomData {
    protected final Chromosome chr1;
    protected final Chromosome chr2;
    protected final boolean isIntra;
    protected final HiCZoom zoom;
    protected final int blockBinCount;
    protected final int blockColumnCount;
    protected final long correctedBinCount;
    protected final BlockCache blockCache;
    protected final V9Depth v9Depth;
    protected final Map<NormalizationType, BasicMatrix> pearsonsMap;
    protected DatasetReader reader;
    protected final Map<String, double[]> eigenvectorMap;
    protected final BlockModifier identity = new IdentityModifier();
    protected final double sumCounts;
    protected final BlockIndices blockIndices;

    public MatrixZoomData(Chromosome chr1, Chromosome chr2, HiCZoom zoom, int blockBinCount, int blockColumnCount, int[] chr1Sites, int[] chr2Sites, DatasetReader reader, BlockIndices blockIndices, boolean useCache, double sumCounts) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.zoom = zoom;
        this.isIntra = chr1.getIndex() == chr2.getIndex();
        this.reader = reader;
        this.blockBinCount = blockBinCount;
        this.blockIndices = blockIndices;
        this.sumCounts = sumCounts;
        this.blockCache = new BlockCache();
        this.v9Depth = reader.getVersion() > 8 ? V9Depth.setDepthMethod(reader.getDepthBase(), blockBinCount) : new LogDepth(2, blockBinCount);
        this.blockColumnCount = blockColumnCount;
        if (!(this instanceof DynamicMatrixZoomData)) {
            if (reader.getVersion() < 8 && chr1.getLength() < chr2.getLength()) {
                boolean isFrag = zoom.getUnit() == HiCZoom.HiCUnit.FRAG;
                long len1 = chr1.getLength();
                long len2 = chr2.getLength();
                if (chr1Sites != null && chr2Sites != null && isFrag) {
                    len1 = chr1Sites.length + 1;
                    len2 = chr2Sites.length + 1;
                }
                long nBinsX = Math.max(len1, len2) / (long)zoom.getBinSize() + 1L;
                this.correctedBinCount = nBinsX / (long)blockColumnCount + 1L;
            } else {
                this.correctedBinCount = blockBinCount;
            }
        } else {
            this.correctedBinCount = blockBinCount;
        }
        this.pearsonsMap = new HashMap<NormalizationType, BasicMatrix>();
        this.eigenvectorMap = new HashMap<String, double[]>();
        this.blockCache.setUseCache(useCache);
    }

    protected MatrixZoomData(MatrixZoomData zd0) {
        this.chr1 = zd0.chr1;
        this.chr2 = zd0.chr2;
        this.isIntra = zd0.isIntra;
        this.zoom = zd0.zoom;
        this.blockBinCount = zd0.blockBinCount;
        this.blockColumnCount = zd0.blockColumnCount;
        this.correctedBinCount = zd0.correctedBinCount;
        this.blockCache = zd0.blockCache;
        this.v9Depth = zd0.v9Depth;
        this.sumCounts = zd0.sumCounts;
        this.reader = zd0.reader;
        this.pearsonsMap = zd0.pearsonsMap;
        this.eigenvectorMap = zd0.eigenvectorMap;
        this.blockIndices = zd0.blockIndices;
    }

    public Chromosome getChr1() {
        return this.chr1;
    }

    public Chromosome getChr2() {
        return this.chr2;
    }

    public int getBinSize() {
        return this.zoom.getBinSize();
    }

    public int getChr1Idx() {
        return this.chr1.getIndex();
    }

    public int getChr2Idx() {
        return this.chr2.getIndex();
    }

    public long getMatrixSize() {
        return this.chr1.getLength() / (long)this.zoom.getBinSize() + 1L;
    }

    public long getCorrectedBinCount() {
        return this.correctedBinCount;
    }

    public int getBlockBinCount() {
        return this.blockBinCount;
    }

    public HiCZoom getZoom() {
        return this.zoom;
    }

    public int getBlockColumnCount() {
        return this.blockColumnCount;
    }

    public static String triKey(String s1, String s2, String s3) {
        return s1 + "_" + s2 + "_" + s3;
    }

    public String getKey() {
        return MatrixZoomData.triKey(this.chr1.getName(), this.chr2.getName(), this.zoom.getKey());
    }

    public String getKey(int chr1, int chr2) {
        return MatrixZoomData.triKey("" + chr1, "" + chr2, this.zoom.getKey());
    }

    public String getBlockKey(int blockNumber, NormalizationType no) {
        return MatrixZoomData.triKey(this.getKey(), "" + blockNumber, "" + no);
    }

    public String getNormLessBlockKey(Block block) {
        return MatrixZoomData.triKey(this.getKey(), "" + block.getNumber(), block.getUniqueRegionID());
    }

    public List<Block> getNormalizedBlocksOverlapping(long binX1, long binY1, long binX2, long binY2, NormalizationType no, boolean fillUnderDiagonal) {
        return this.getNormalizedBlocksOverlapping(binX1, binY1, binX2, binY2, no, fillUnderDiagonal, this.identity);
    }

    public List<Block> getNormalizedBlocksOverlapping(long binX1, long binY1, long binX2, long binY2, NormalizationType no, boolean fillUnderDiagonal, BlockModifier modifier) {
        List<Block> blockList = Collections.synchronizedList(new ArrayList());
        if (this.reader.getVersion() > 8 && this.isIntra) {
            return V9IntraBlockReader.addNormalizedBlocksToListV9(blockList, (int)binX1, (int)binY1, (int)binX2, (int)binY2, no, modifier, this.blockBinCount, this.v9Depth, this.blockColumnCount, this.blockCache, this.getKey(), this.chr1, this.chr2, this.zoom, this.reader, this.blockIndices);
        }
        return LegacyVersionBlockReader.addNormalizedBlocksToList(blockList, (int)binX1, (int)binY1, (int)binX2, (int)binY2, no, fillUnderDiagonal, modifier, this.blockBinCount, this.blockColumnCount, this.blockCache, this.getKey(), this.chr1, this.chr2, this.zoom, this.reader, this.blockIndices);
    }

    public String getDescription() {
        return this.chr1.getName() + " - " + this.chr2.getName() + " - " + this.getZoom();
    }

    public void printFullDescription() {
        System.out.println("Chromosomes: " + this.chr1.getName() + " - " + this.chr2.getName());
        System.out.println("unit: " + (Object)((Object)this.zoom.getUnit()));
        System.out.println("binSize (bp): " + this.zoom.getBinSize());
        System.out.println("blockBinCount (bins): " + this.blockBinCount);
        System.out.println("blockColumnCount (columns): " + this.blockColumnCount);
        System.out.println("Block size (bp): " + this.blockBinCount * this.zoom.getBinSize());
        System.out.println();
    }

    protected List<Integer> getBlockNumbersForRegionFromGenomePosition(long[] regionIndices) {
        int resolution = this.zoom.getBinSize();
        long[] regionBinIndices = new long[4];
        for (int i = 0; i < regionBinIndices.length; ++i) {
            regionBinIndices[i] = regionIndices[i] / (long)resolution;
        }
        return this.getBlockNumbersForRegionFromBinPosition(regionBinIndices);
    }

    private List<Integer> getBlockNumbersForRegionFromBinPosition(long[] regionBinIndices) {
        if (this.reader.getVersion() > 8 && this.isIntra) {
            return V9IntraBlockReader.getBlockNumbersForRegionFromBinPosition(regionBinIndices, this.blockBinCount, this.blockColumnCount, this.v9Depth);
        }
        return LegacyVersionBlockReader.getBlockNumbersForRegionFromBinPosition(regionBinIndices, this.blockBinCount, this.blockColumnCount, this.isIntra);
    }

    public double getAverageCount() {
        long nBins1 = this.chr1.getLength() / (long)this.zoom.getBinSize();
        long nBins2 = this.chr2.getLength() / (long)this.zoom.getBinSize();
        return this.sumCounts / (double)nBins1 / (double)nBins2;
    }

    void clearCache() {
        this.blockCache.clear();
        this.pearsonsMap.clear();
        this.eigenvectorMap.clear();
        if (this.blockIndices != null) {
            this.blockIndices.clearCache();
        }
    }

    public Integer getBlockSize(int blockNum) {
        Integer blockSize = this.blockIndices != null ? this.blockIndices.getBlockSize(blockNum) : null;
        return blockSize;
    }

    public Iterator<ContactRecord> getDirectIterator() {
        return new ContactRecordIterator(this.reader, this.blockIndices, this.getKey(), this.blockCache, this.getChr1Idx(), this.getChr2Idx(), this.getZoom(), NormalizationHandler.NONE);
    }

    public Iterator<ContactRecord> getNormalizedIterator(NormalizationType normType) {
        return new ContactRecordIterator(this.reader, this.blockIndices, this.getKey(), this.blockCache, this.getChr1Idx(), this.getChr2Idx(), this.getZoom(), normType);
    }

    public BasicMatrix getPearsons(ExpectedValueFunction df) {
        if (this.chr1.getIndex() != this.chr2.getIndex()) {
            throw new RuntimeException("Cannot compute pearsons for non-diagonal matrices");
        }
        BasicMatrix pearsons = this.pearsonsMap.get(df.getNormalizationType());
        if (pearsons != null) {
            return pearsons;
        }
        pearsons = PearsonsManager.computePearsons(df, this.getDirectIterator(), this.chr1, this.zoom.getBinSize());
        this.pearsonsMap.put(df.getNormalizationType(), pearsons);
        return this.pearsonsMap.get(df.getNormalizationType());
    }

    protected BasicMatrix getPearsons(NormalizationType type) {
        return this.pearsonsMap.get(type);
    }

    public float getPearsonValue(int binX, int binY, NormalizationType type) {
        BasicMatrix pearsons = this.pearsonsMap.get(type);
        if (pearsons != null) {
            return pearsons.getEntry(binX, binY);
        }
        return 0.0f;
    }

    public double[] getEigenvector(ExpectedValueFunction df, int which) {
        if (this.chr1.getIndex() != this.chr2.getIndex()) {
            throw new RuntimeException("Cannot compute eigenvector for non-diagonal matrices");
        }
        String eigKey = this.getEigenvectorKey(df.getNormalizationType(), which);
        double[] eig = this.eigenvectorMap.get(eigKey);
        if (eig != null) {
            return eig;
        }
        BasicMatrix pearsons = this.getPearsons(df);
        if (pearsons == null) {
            return null;
        }
        eig = PearsonsManager.computeEigenvector(pearsons, which);
        this.eigenvectorMap.put(eigKey, eig);
        return this.eigenvectorMap.get(eigKey);
    }

    protected String getEigenvectorKey(NormalizationType normalizationType, int which) {
        return normalizationType.getLabel() + "_" + which;
    }

    protected double[] getEigenvector(NormalizationType normalizationType, int which) {
        return this.eigenvectorMap.get(this.getEigenvectorKey(normalizationType, which));
    }
}

