/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.mzd;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javastraw.reader.IntPair;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.mzd.DynamicMatrixZoomData;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;

public class Matrix {
    private final int chr1;
    private final int chr2;
    private static final Set<IntPair> dynamicZoomResolutions = new HashSet<IntPair>();
    protected final List<MatrixZoomData> bpZoomData = new ArrayList<MatrixZoomData>();
    protected final List<MatrixZoomData> fragZoomData = new ArrayList<MatrixZoomData>();
    protected final List<MatrixZoomData> dynamicBPZoomData = new ArrayList<MatrixZoomData>();
    private final Comparator<MatrixZoomData> comparator = (o1, o2) -> o2.getBinSize() - o1.getBinSize();

    public Matrix(int chr1, int chr2, List<MatrixZoomData> zoomDataList) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.initZoomDataMap(zoomDataList);
    }

    private void initZoomDataMap(List<MatrixZoomData> zoomDataList) {
        for (MatrixZoomData zd : zoomDataList) {
            if (zd.getZoom().getUnit() == HiCZoom.HiCUnit.BP) {
                this.bpZoomData.add(zd);
            } else {
                this.fragZoomData.add(zd);
            }
            this.bpZoomData.sort(this.comparator);
            this.fragZoomData.sort(this.comparator);
        }
        for (IntPair resPair : dynamicZoomResolutions) {
            try {
                this.createDynamicResolutionMZD(resPair, false);
            }
            catch (Exception e) {
                System.err.println("Dynamic resolution could not be made");
            }
        }
        this.dynamicBPZoomData.sort(this.comparator);
    }

    public static String generateKey(int chr1, int chr2) {
        if (chr2 < chr1) {
            return "" + chr2 + "_" + chr1;
        }
        return "" + chr1 + "_" + chr2;
    }

    public void createDynamicResolutionMZD(IntPair resPair, boolean addToSet) {
        int newRes = resPair.a;
        int highRes = resPair.b;
        MatrixZoomData highMZD = this.getZoomData(new HiCZoom(HiCZoom.HiCUnit.BP, highRes));
        DynamicMatrixZoomData newMZD = new DynamicMatrixZoomData(new HiCZoom(HiCZoom.HiCUnit.BP, newRes), highMZD);
        if (addToSet) {
            dynamicZoomResolutions.add(resPair);
        }
        this.dynamicBPZoomData.add(newMZD);
    }

    public static String generateKey(Chromosome chr1, Chromosome chr2) {
        int t1 = Math.min(chr1.getIndex(), chr2.getIndex());
        int t2 = Math.max(chr1.getIndex(), chr2.getIndex());
        return Matrix.generateKey(t1, t2);
    }

    public String getKey() {
        return Matrix.generateKey(this.chr1, this.chr2);
    }

    public MatrixZoomData getFirstZoomData() {
        if (this.bpZoomData != null && this.bpZoomData.size() > 0) {
            return this.getFirstZoomData(HiCZoom.HiCUnit.BP);
        }
        return this.getFirstZoomData(HiCZoom.HiCUnit.FRAG);
    }

    public MatrixZoomData getFirstZoomData(HiCZoom.HiCUnit unit) {
        if (unit == HiCZoom.HiCUnit.BP) {
            return this.bpZoomData != null && this.bpZoomData.size() > 0 ? this.bpZoomData.get(0) : null;
        }
        return this.fragZoomData != null && this.fragZoomData.size() > 0 ? this.fragZoomData.get(0) : null;
    }

    public MatrixZoomData getFirstPearsonZoomData(HiCZoom.HiCUnit unit) {
        if (unit == HiCZoom.HiCUnit.BP) {
            return this.bpZoomData != null ? this.bpZoomData.get(2) : null;
        }
        return this.fragZoomData != null ? this.fragZoomData.get(2) : null;
    }

    public MatrixZoomData getZoomData(HiCZoom zoom) {
        int targetZoom = zoom.getBinSize();
        List<MatrixZoomData> zdList = zoom.getUnit() == HiCZoom.HiCUnit.BP ? this.bpZoomData : this.fragZoomData;
        for (MatrixZoomData zd : zdList) {
            if (zd.getBinSize() != targetZoom) continue;
            return zd;
        }
        for (MatrixZoomData zd : this.dynamicBPZoomData) {
            if (zd.getBinSize() != targetZoom) continue;
            return zd;
        }
        if (this.chr1 == 0 && this.chr2 == 0) {
            MatrixZoomData closestValue = zdList.get(0);
            int distance = Math.abs(closestValue.getBinSize() - targetZoom);
            for (MatrixZoomData zd : zdList) {
                int cdistance = Math.abs(zd.getBinSize() - targetZoom);
                if (cdistance >= distance) continue;
                closestValue = zd;
                distance = cdistance;
            }
            return closestValue;
        }
        return null;
    }

    public int getNumberOfZooms(HiCZoom.HiCUnit unit) {
        return unit == HiCZoom.HiCUnit.BP ? this.bpZoomData.size() : this.fragZoomData.size();
    }

    public boolean isNotIntra() {
        return this.chr1 != this.chr2;
    }

    public boolean isIntra() {
        return this.chr1 == this.chr2;
    }

    public void clearCache() {
        this.clearOut(this.bpZoomData);
        this.clearOut(this.fragZoomData);
        this.clearOut(this.dynamicBPZoomData);
    }

    public void clearCacheForZoom(HiCZoom zoom) {
        this.clearSpecificResolution(this.bpZoomData, zoom);
        this.clearSpecificResolution(this.fragZoomData, zoom);
        this.clearSpecificResolution(this.dynamicBPZoomData, zoom);
    }

    private void clearOut(List<MatrixZoomData> zoomData) {
        for (MatrixZoomData mzd : zoomData) {
            this.tryToClear(mzd);
        }
        zoomData.clear();
    }

    private void clearSpecificResolution(List<MatrixZoomData> zoomData, HiCZoom zoom) {
        ArrayList<MatrixZoomData> toDelete = new ArrayList<MatrixZoomData>();
        for (MatrixZoomData mzd : zoomData) {
            if (mzd.getZoom().getBinSize() != zoom.getBinSize()) continue;
            toDelete.add(mzd);
        }
        zoomData.removeAll(toDelete);
        for (MatrixZoomData mzd : toDelete) {
            this.tryToClear(mzd);
        }
        toDelete.clear();
    }

    private void tryToClear(MatrixZoomData mzd) {
        try {
            mzd.clearCache();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

