/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.mzd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javastraw.reader.DatasetReader;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.Block;
import javastraw.reader.block.BlockIndices;
import javastraw.reader.block.BlockModifier;
import javastraw.reader.mzd.BlockCache;
import javastraw.reader.mzd.BlockLoader;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;

public class LegacyVersionBlockReader {
    public static List<Block> addNormalizedBlocksToList(List<Block> blockList, int binX1, int binY1, int binX2, int binY2, NormalizationType norm, boolean getBelowDiagonal, BlockModifier modifier, int blockBinCount, int blockColumnCount, BlockCache blockCache, String zdKey, Chromosome chrom1, Chromosome chrom2, HiCZoom zoom, DatasetReader reader, BlockIndices blockIndices) {
        int c;
        int r;
        HashSet<Integer> blocksToLoad = new HashSet<Integer>();
        int col1 = binX1 / blockBinCount;
        int row1 = binY1 / blockBinCount;
        int col2 = binX2 / blockBinCount;
        int row2 = binY2 / blockBinCount;
        for (r = row1; r <= row2; ++r) {
            for (c = col1; c <= col2; ++c) {
                LegacyVersionBlockReader.populateBlocksToLoad(r, c, norm, blockList, blocksToLoad, blockColumnCount, blockCache, zdKey);
            }
        }
        if (getBelowDiagonal && binY1 < binX2) {
            for (r = row1; r <= row2; ++r) {
                for (c = col1; c <= col2; ++c) {
                    LegacyVersionBlockReader.populateBlocksToLoad(c, r, norm, blockList, blocksToLoad, blockColumnCount, blockCache, zdKey);
                }
            }
        }
        BlockLoader.actuallyLoadGivenBlocks(blockList, new ArrayList<Integer>(blocksToLoad), norm, modifier, zdKey, chrom1, chrom2, zoom, blockCache, reader, blockIndices);
        return new ArrayList<Block>(new HashSet<Block>(blockList));
    }

    protected static void populateBlocksToLoad(int r, int c, NormalizationType no, List<Block> blockList, Set<Integer> blocksToLoad, int blockColumnCount, BlockCache blockCache, String zdKey) {
        int blockNumber = r * blockColumnCount + c;
        String key = BlockLoader.getBlockKey(zdKey, blockNumber, no);
        if (blockCache.containsKey(key)) {
            Block b = blockCache.get(key);
            blockList.add(b);
        } else {
            blocksToLoad.add(blockNumber);
        }
    }

    public static List<Integer> getBlockNumbersForRegionFromBinPosition(long[] regionIndices, int blockBinCount, int blockColumnCount, boolean isIntra) {
        int blockNumber;
        int c;
        int r;
        int row1 = (int)(regionIndices[0] / (long)blockBinCount);
        int row2 = (int)((regionIndices[1] + 1L) / (long)blockBinCount);
        int col1 = (int)(regionIndices[2] / (long)blockBinCount);
        int col2 = (int)((regionIndices[3] + 1L) / (long)blockBinCount);
        HashSet<Integer> blocksSet = new HashSet<Integer>();
        for (r = row1; r <= row2; ++r) {
            for (c = col1; c <= col2; ++c) {
                blockNumber = r * blockColumnCount + c;
                blocksSet.add(blockNumber);
            }
        }
        if (isIntra) {
            for (r = col1; r <= col2; ++r) {
                for (c = row1; c <= row2; ++c) {
                    blockNumber = r * blockColumnCount + c;
                    blocksSet.add(blockNumber);
                }
            }
        }
        ArrayList<Integer> blocksToIterateOver = new ArrayList<Integer>(blocksSet);
        Collections.sort(blocksToIterateOver);
        return blocksToIterateOver;
    }
}

