/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.mzd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javastraw.reader.DatasetReader;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.Block;
import javastraw.reader.block.BlockIndices;
import javastraw.reader.block.BlockModifier;
import javastraw.reader.block.IndexEntry;
import javastraw.reader.mzd.BlockCache;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.ParallelizationTools;

public class BlockLoader {
    public static void actuallyLoadGivenBlocks(List<Block> globalBlockList, List<Integer> blockIds, NormalizationType no, BlockModifier modifier, String zdKey, Chromosome chrom1, Chromosome chrom2, HiCZoom zoom, BlockCache globalBlockCache, DatasetReader reader, BlockIndices blockIndex) {
        AtomicInteger errorCounter = new AtomicInteger();
        Object listLock = new Object();
        Object cacheLock = new Object();
        HashSet globalBlockSet = new HashSet();
        int numJobs = Math.min(blockIds.size(), 8);
        AtomicInteger index = new AtomicInteger(0);
        ParallelizationTools.launchParallelizedCode(numJobs, () -> {
            ArrayList<Block> blockList = new ArrayList<Block>();
            BlockCache blockCache = new BlockCache();
            int i = index.getAndIncrement();
            while (i < blockIds.size()) {
                int blockNumber = (Integer)blockIds.get(i);
                String key = BlockLoader.getBlockKey(zdKey, blockNumber, no);
                try {
                    BlockLoader.getBlockFromReader(blockList, no, modifier, zdKey, chrom1, chrom2, zoom, blockCache, reader, blockNumber, key, blockIndex.getBlock(blockNumber));
                }
                catch (IOException e) {
                    errorCounter.incrementAndGet();
                }
                i = index.getAndIncrement();
            }
            Object object = listLock;
            synchronized (object) {
                globalBlockSet.addAll(blockList);
            }
            blockList.clear();
            object = cacheLock;
            synchronized (object) {
                globalBlockCache.addAll(blockCache);
            }
            blockCache.clear();
        });
        globalBlockList.addAll(globalBlockSet);
    }

    private static void getBlockFromReader(List<Block> blockList, NormalizationType no, BlockModifier modifier, String zdKey, Chromosome chrom1, Chromosome chrom2, HiCZoom zoom, BlockCache blockCache, DatasetReader reader, int blockNumber, String key, IndexEntry idx) throws IOException {
        Block b = reader.readNormalizedBlock(blockNumber, zdKey, no, chrom1.getIndex(), chrom2.getIndex(), zoom, idx);
        if (b == null) {
            b = new Block(blockNumber, key);
        }
        b = modifier.modify(b, key, zoom.getBinSize(), chrom1, chrom2);
        blockCache.put(key, b);
        blockList.add(b);
    }

    public static String getBlockKey(String zdKey, int blockNumber, NormalizationType no) {
        return MatrixZoomData.triKey(zdKey, "" + blockNumber, "" + no);
    }
}

