/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.mzd;

import java.util.HashSet;
import javastraw.reader.block.Block;
import org.broad.igv.util.collections.LRUCache;

public class BlockCache {
    LRUCache<String, Block> cache = new LRUCache(500);
    private boolean useCache = true;

    public void clear() {
        this.cache.clear();
    }

    public void put(String key, Block b) {
        if (this.useCache) {
            this.cache.put(key, b);
        }
    }

    public boolean containsKey(String key) {
        return this.useCache && this.cache.containsKey(key);
    }

    public Block get(String key) {
        if (this.useCache) {
            return this.cache.get(key);
        }
        System.err.println("Invalid situation - cache is not set");
        System.exit(9);
        return null;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
        if (!useCache) {
            this.cache.clear();
        }
    }

    public void addAll(BlockCache other) {
        if (this.useCache) {
            HashSet<String> keys2 = new HashSet<String>(other.cache.keySet());
            for (String key : keys2) {
                this.cache.put(key, other.cache.get(key));
            }
        }
    }

    public boolean getUseCache() {
        return this.useCache;
    }
}

