/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.iterators;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javastraw.reader.DatasetReader;
import javastraw.reader.block.Block;
import javastraw.reader.block.BlockIndices;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.BlockCache;
import javastraw.reader.mzd.BlockLoader;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;

public class ContactRecordIterator
implements Iterator<ContactRecord> {
    private final List<Integer> blockNumbers;
    private final BlockIndices blockIndices;
    private Iterator<ContactRecord> currentBlockIterator;
    private final DatasetReader reader;
    private final String zdKey;
    private final BlockCache blockCache;
    private final int chr1Idx;
    private final int chr2Idx;
    private final HiCZoom zoom;
    private final NormalizationType normType;
    private int currentBlockIdx;

    public ContactRecordIterator(DatasetReader reader, BlockIndices blockIndices, String zdKey, BlockCache blockCache, int chr1Idx, int chr2Idx, HiCZoom zoom, NormalizationType normType) {
        this.reader = reader;
        this.blockIndices = blockIndices;
        this.zdKey = zdKey;
        this.chr1Idx = chr1Idx;
        this.chr2Idx = chr2Idx;
        this.zoom = zoom;
        this.blockCache = blockCache;
        this.currentBlockIdx = -1;
        this.normType = normType;
        this.blockNumbers = blockIndices.getBlockNumbers();
    }

    @Override
    public boolean hasNext() {
        if (this.blockNumbers == null || this.blockNumbers.size() == 0) {
            System.err.println("ERROR: No blocks available for " + this.zdKey + ". Verify dynamic blocks not being used or that cache has not been cleared early.");
            return false;
        }
        if (this.currentBlockIterator != null && this.currentBlockIterator.hasNext()) {
            return true;
        }
        ++this.currentBlockIdx;
        while (this.currentBlockIdx < this.blockNumbers.size()) {
            try {
                int blockNumber = this.blockNumbers.get(this.currentBlockIdx);
                String key = BlockLoader.getBlockKey(this.zdKey, blockNumber, this.normType);
                Block nextBlock = this.blockCache.containsKey(key) ? this.blockCache.get(key) : this.reader.readNormalizedBlock(blockNumber, this.zdKey, this.normType, this.chr1Idx, this.chr2Idx, this.zoom, this.blockIndices.getBlock(blockNumber));
                List<ContactRecord> contactRecords = nextBlock.getContactRecords();
                if (contactRecords != null && contactRecords.size() > 0) {
                    this.currentBlockIterator = contactRecords.iterator();
                    return true;
                }
            }
            catch (IOException e) {
                System.err.println("Error fetching block " + e.getMessage());
                return false;
            }
            ++this.currentBlockIdx;
        }
        this.blockNumbers.clear();
        return false;
    }

    @Override
    public ContactRecord next() {
        return this.currentBlockIterator == null ? null : this.currentBlockIterator.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("remove() is not supported");
    }
}

