/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.expected;

import java.io.IOException;
import java.util.Map;
import javastraw.reader.DatasetReader;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;

public class ExpectedValueFunctionImpl
implements ExpectedValueFunction {
    private final DatasetReader reader;
    private final int binSize;
    private final NormalizationType type;
    private final HiCZoom.HiCUnit unit;
    private final Map<Integer, Double> normFactors;
    private final long nValues;
    private final long filePosition;
    private final int streamSize = 500000;
    private int version = -1;
    private ListOfDoubleArrays expectedValues;
    private long streamBound1 = 0L;
    private long streamBound2 = 0L;

    public ExpectedValueFunctionImpl(NormalizationType type, HiCZoom.HiCUnit unit, int binSize, ListOfDoubleArrays expectedValues, Map<Integer, Double> normFactors) {
        this.type = type;
        this.unit = unit;
        this.binSize = binSize;
        this.normFactors = normFactors;
        this.expectedValues = expectedValues;
        this.nValues = expectedValues.getLength();
        this.filePosition = 0L;
        this.reader = null;
    }

    public ExpectedValueFunctionImpl(NormalizationType type, HiCZoom.HiCUnit unit, int binSize, long nValues, long filePosition, Map<Integer, Double> normFactors, DatasetReader reader) {
        this.type = type;
        this.unit = unit;
        this.binSize = binSize;
        this.normFactors = normFactors;
        this.expectedValues = null;
        this.nValues = nValues;
        this.filePosition = filePosition;
        this.reader = reader;
        this.version = reader.getVersion();
    }

    public Map<Integer, Double> getNormFactors() {
        return this.normFactors;
    }

    @Override
    public ListOfDoubleArrays getExpectedValuesNoNormalization() {
        this.streamExpectedVectorFromFileIfNeeded();
        return this.expectedValues;
    }

    private void streamExpectedVectorFromFileIfNeeded() {
        if (this.expectedValues == null && this.streamBound1 == 0L && this.streamBound2 == 0L) {
            try {
                this.expectedValues = this.reader.readExpectedVectorPart(this.filePosition, this.nValues);
                this.streamBound1 = 0L;
                this.streamBound2 = 0L;
            }
            catch (IOException e) {
                System.err.println("Error reading expected vector");
                e.printStackTrace();
            }
        }
    }

    @Override
    public double getExpectedValue(int chrIdx, long distance) {
        double normFactor = 1.0;
        if (this.normFactors != null && this.normFactors.containsKey(chrIdx)) {
            normFactor = this.normFactors.get(chrIdx);
        }
        if (this.expectedValues == null) {
            this.streamPortionOfExpectedVector(distance);
        }
        if (this.streamBound1 == 0L && this.streamBound2 == 0L) {
            if (this.expectedValues.getLength() > 0L) {
                if (distance >= this.expectedValues.getLength()) {
                    return this.expectedValues.getLastValue() / normFactor;
                }
                return this.expectedValues.get(distance) / normFactor;
            }
            System.err.println("Expected values array is empty");
            return -1.0;
        }
        if (distance >= this.streamBound1 && distance < this.streamBound2) {
            long streamIndex = distance - this.streamBound1;
            return this.expectedValues.get(streamIndex) / normFactor;
        }
        this.streamPortionOfExpectedVector(distance);
        long streamIndex = distance - this.streamBound1;
        return this.expectedValues.get(streamIndex) / normFactor;
    }

    private void streamPortionOfExpectedVector(long distance) {
        this.streamBound1 = Math.max(0L, distance - 250000L);
        this.streamBound2 = this.streamBound1 + 500000L;
        long position = this.version > 8 ? this.filePosition + this.streamBound1 * 4L : this.filePosition + this.streamBound1 * 8L;
        try {
            this.expectedValues = this.reader.readExpectedVectorPart(position, 500000L);
        }
        catch (IOException e) {
            System.err.println("Error reading expected vector");
            e.printStackTrace();
        }
    }

    @Override
    public ListOfDoubleArrays getExpectedValuesWithNormalization(int chrIdx) {
        this.streamExpectedVectorFromFileIfNeeded();
        double normFactor = 1.0;
        if (this.normFactors != null && this.normFactors.containsKey(chrIdx)) {
            normFactor = this.normFactors.get(chrIdx);
        }
        if (this.expectedValues.getLength() > 0L) {
            ListOfDoubleArrays normedExpectedValues = this.expectedValues.deepClone();
            normedExpectedValues.multiplyEverythingBy(1.0 / normFactor);
            return normedExpectedValues;
        }
        System.err.println("Expected values array is empty");
        return null;
    }

    @Override
    public ExpectedValueFunction getCorrectedVersion(int window) {
        this.streamExpectedVectorFromFileIfNeeded();
        ListOfDoubleArrays smoothVector = this.expectedValues.deepClone();
        smoothVector.doRollingMedian(window / this.binSize);
        return new ExpectedValueFunctionImpl(this.type, this.unit, this.binSize, smoothVector, this.normFactors);
    }

    @Override
    public long getLength() {
        return this.nValues;
    }

    @Override
    public NormalizationType getNormalizationType() {
        return this.type;
    }

    @Override
    public HiCZoom.HiCUnit getUnit() {
        return this.unit;
    }

    @Override
    public int getBinSize() {
        return this.binSize;
    }
}

