/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.depth;

import javastraw.reader.depth.ConstantDepth;
import javastraw.reader.depth.LogDepth;

public abstract class V9Depth {
    protected final int blockBinCount;
    protected double BASE;

    V9Depth(int blockBinCount) {
        this.blockBinCount = blockBinCount;
    }

    public static V9Depth setDepthMethod(int depthBase, int blockBinCount) {
        if (depthBase > 1) {
            return new LogDepth(depthBase, blockBinCount);
        }
        if (depthBase < 0) {
            return new ConstantDepth(-depthBase, blockBinCount);
        }
        return new LogDepth(2, blockBinCount);
    }

    public int getDepth(int val1, int val2) {
        return this.logBase((double)Math.abs(val1 - val2) / Math.sqrt(2.0) / (double)this.blockBinCount);
    }

    public int getDepth(long val1, long val2) {
        return this.logBase((double)Math.abs(val1 - val2) / Math.sqrt(2.0) / (double)this.blockBinCount);
    }

    protected abstract int logBase(double var1);
}

