/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.datastructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListOfIntArrays {
    private final int DEFAULT_LENGTH = 0x7FFFFFF5;
    private final long overallLength;
    private final List<int[]> internalList = new ArrayList<int[]>();

    public ListOfIntArrays(long length) {
        this.overallLength = length;
        for (long tempLength = length; tempLength > 0L; tempLength -= 0x7FFFFFF5L) {
            if (tempLength < 0x7FFFFFF5L) {
                this.internalList.add(new int[(int)tempLength]);
                break;
            }
            this.internalList.add(new int[0x7FFFFFF5]);
        }
    }

    public ListOfIntArrays(long totSize, int defaultValue) {
        this(totSize);
        for (int[] array : this.internalList) {
            Arrays.fill(array, defaultValue);
        }
    }

    public void clear() {
        this.internalList.clear();
    }

    public int get(long index) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 0x7FFFFFF5L);
            int pseudoCol = (int)(index % 0x7FFFFFF5L);
            return this.internalList.get(pseudoRow)[pseudoCol];
        }
        System.err.println("long index exceeds max size of list of int arrays while getting");
        return -2147483647;
    }

    public void set(long index, int value) {
        long tempIndex = index;
        if (index >= this.overallLength) {
            System.err.println("long index exceeds max size of list of arrays while setting");
            return;
        }
        int pseudoRow = (int)(index / 0x7FFFFFF5L);
        int pseudoCol = (int)(index % 0x7FFFFFF5L);
        this.internalList.get((int)pseudoRow)[pseudoCol] = value;
    }

    public long getLength() {
        return this.overallLength;
    }

    public ListOfIntArrays deepClone() {
        ListOfIntArrays clone = new ListOfIntArrays(this.overallLength);
        for (int k = 0; k < this.internalList.size(); ++k) {
            System.arraycopy(this.internalList.get(k), 0, clone.internalList.get(k), 0, this.internalList.get(k).length);
        }
        return clone;
    }

    public void divideBy(long index, int value) {
        if (index >= this.overallLength) {
            System.err.println("long index exceeds max size of list of arrays while dividing");
            return;
        }
        int pseudoRow = (int)(index / 0x7FFFFFF5L);
        int pseudoCol = (int)(index % 0x7FFFFFF5L);
        int[] nArray = this.internalList.get(pseudoRow);
        int n = pseudoCol;
        nArray[n] = nArray[n] / value;
        System.err.println("unusual - long index exceeds max size of list of arrays while dividing");
    }

    public void addValuesFrom(ListOfIntArrays other) {
        if (this.overallLength == other.overallLength) {
            for (int i = 0; i < this.internalList.size(); ++i) {
                for (int j = 0; j < this.internalList.get(i).length; ++j) {
                    int[] nArray = this.internalList.get(i);
                    int n = j;
                    nArray[n] = nArray[n] + other.internalList.get(i)[j];
                }
            }
        } else {
            System.err.println("Adding objects of different sizes!");
        }
    }

    public void addTo(long index, int value) {
        if (index >= this.overallLength) {
            System.err.println("long index exceeds max size of list of arrays while adding");
            return;
        }
        int pseudoRow = (int)(index / 0x7FFFFFF5L);
        int pseudoCol = (int)(index % 0x7FFFFFF5L);
        int[] nArray = this.internalList.get(pseudoRow);
        int n = pseudoCol;
        nArray[n] = nArray[n] + value;
    }

    public List<int[]> getValues() {
        return this.internalList;
    }
}

