/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.datastructures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javastraw.reader.datastructures.ListOfDoubleArrays;

public class ListOfFloatArrays {
    private final long DEFAULT_LENGTH = 0x7FFFFFF5L;
    private final long overallLength;
    private final List<float[]> internalList = new ArrayList<float[]>();

    public ListOfFloatArrays(long length) {
        this.overallLength = length;
        for (long tempLength = length; tempLength > 0L; tempLength -= 0x7FFFFFF5L) {
            if (tempLength < 0x7FFFFFF5L) {
                this.internalList.add(new float[(int)tempLength]);
                break;
            }
            this.internalList.add(new float[0x7FFFFFF5]);
        }
    }

    public ListOfFloatArrays(long totSize, float defaultValue) {
        this(totSize);
        for (float[] array : this.internalList) {
            Arrays.fill(array, defaultValue);
        }
    }

    public void clear() {
        this.internalList.clear();
    }

    public float get(long index) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 0x7FFFFFF5L);
            int pseudoCol = (int)(index % 0x7FFFFFF5L);
            return this.internalList.get(pseudoRow)[pseudoCol];
        }
        System.err.println("long index exceeds max size of list of arrays while getting: " + index + " " + this.overallLength);
        Exception ioe = new Exception();
        ioe.printStackTrace();
        return Float.NaN;
    }

    public void set(long index, float value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 0x7FFFFFF5L);
            int pseudoCol = (int)(index % 0x7FFFFFF5L);
            this.internalList.get((int)pseudoRow)[pseudoCol] = value;
        } else {
            System.err.println("long index exceeds max size of list of arrays while setting");
        }
    }

    public long getLength() {
        return this.overallLength;
    }

    public ListOfFloatArrays deepClone() {
        ListOfFloatArrays clone = new ListOfFloatArrays(this.overallLength);
        for (int k = 0; k < this.internalList.size(); ++k) {
            System.arraycopy(this.internalList.get(k), 0, clone.internalList.get(k), 0, this.internalList.get(k).length);
        }
        return clone;
    }

    public void divideBy(long index, float value) {
        if (index >= this.overallLength) {
            System.err.println("long index exceeds max size of list of arrays while dividing");
            return;
        }
        int pseudoRow = (int)(index / 0x7FFFFFF5L);
        int pseudoCol = (int)(index % 0x7FFFFFF5L);
        float[] fArray = this.internalList.get(pseudoRow);
        int n = pseudoCol;
        fArray[n] = fArray[n] / value;
    }

    public void multiplyBy(long index, float value) {
        if (index >= this.overallLength) {
            System.err.println("long index exceeds max size of list of arrays while mutiplying");
            return;
        }
        int pseudoRow = (int)(index / 0x7FFFFFF5L);
        int pseudoCol = (int)(index % 0x7FFFFFF5L);
        float[] fArray = this.internalList.get(pseudoRow);
        int n = pseudoCol;
        fArray[n] = fArray[n] * value;
    }

    public void addTo(long index, float value) {
        if (index < this.overallLength) {
            int pseudoRow = (int)(index / 0x7FFFFFF5L);
            int pseudoCol = (int)(index % 0x7FFFFFF5L);
            try {
                float[] fArray = this.internalList.get(pseudoRow);
                int n = pseudoCol;
                fArray[n] = fArray[n] + value;
            }
            catch (Exception e) {
                System.err.println(index + " " + pseudoCol);
                e.printStackTrace();
            }
        } else {
            System.err.println("long index exceeds max size of list of arrays while adding: " + index + " " + this.overallLength);
            Exception ioe = new Exception();
            ioe.printStackTrace();
        }
    }

    public void addValuesFrom(ListOfFloatArrays other) {
        if (this.overallLength == other.overallLength) {
            for (int i = 0; i < this.internalList.size(); ++i) {
                for (int j = 0; j < this.internalList.get(i).length; ++j) {
                    float[] fArray = this.internalList.get(i);
                    int n = j;
                    fArray[n] = fArray[n] + other.internalList.get(i)[j];
                }
            }
        } else {
            System.err.println("Adding objects of different sizes!");
        }
    }

    public float getFirstValue() {
        return this.internalList.get(0)[0];
    }

    public float getLastValue() {
        float[] temp = this.internalList.get(this.internalList.size() - 1);
        return temp[temp.length - 1];
    }

    public List<float[]> getValues() {
        return this.internalList;
    }

    public void multiplyEverythingBy(double val) {
        for (float[] array : this.internalList) {
            int k = 0;
            while (k < array.length) {
                int n = k++;
                array[n] = (float)((double)array[n] * val);
            }
        }
    }

    public ListOfDoubleArrays convertToDoubles() {
        ListOfDoubleArrays newList = new ListOfDoubleArrays(this.overallLength);
        for (int j = 0; j < this.internalList.size(); ++j) {
            for (int k = 0; k < this.internalList.get(j).length; ++k) {
                newList.getValues().get((int)j)[k] = this.internalList.get(j)[k];
            }
        }
        return newList;
    }
}

