/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.block;

import java.util.Objects;
import javastraw.reader.type.NormalizationType;

public class ContactRecord
implements Comparable<ContactRecord> {
    private final int binX;
    private final int binY;
    private float counts;

    public ContactRecord(int binX, int binY, float counts) {
        this.binX = binX;
        this.binY = binY;
        this.counts = counts;
    }

    public void incrementCount(float score) {
        this.counts += score;
    }

    public int getBinX() {
        return this.binX;
    }

    public int getBinY() {
        return this.binY;
    }

    public float getCounts() {
        return this.counts;
    }

    @Override
    public int compareTo(ContactRecord contactRecord) {
        if (this.binX != contactRecord.binX) {
            return this.binX - contactRecord.binX;
        }
        if (this.binY != contactRecord.binY) {
            return this.binY - contactRecord.binY;
        }
        float val = this.counts - contactRecord.counts;
        if (val > 0.0f) {
            return 1;
        }
        if (val < 0.0f) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "" + this.binX + " " + this.binY + " " + this.counts;
    }

    public int hashCode() {
        return Objects.hash(this.binX, this.binY, Float.valueOf(this.counts));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.compareTo((ContactRecord)obj) == 0;
    }

    public String getKey(NormalizationType normalizationType) {
        return this.binX + "_" + this.binY + "_" + normalizationType;
    }
}

