/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.block;

import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javastraw.reader.block.IndexEntry;

public class BlockIndices {
    protected final Map<Integer, IndexEntry> blockIndices;
    protected final int numBlocks;

    public BlockIndices(int nBlocks) {
        this.numBlocks = nBlocks;
        this.blockIndices = new HashMap<Integer, IndexEntry>(nBlocks);
    }

    public void populateBlocks(LittleEndianInputStream dis) throws IOException {
        for (int b = 0; b < this.numBlocks; ++b) {
            int blockNumber = dis.readInt();
            long filePosition = dis.readLong();
            int blockSizeInBytes = dis.readInt();
            this.blockIndices.put(blockNumber, new IndexEntry(filePosition, blockSizeInBytes));
        }
    }

    public List<Integer> getBlockNumbers() {
        return new ArrayList<Integer>(this.blockIndices.keySet());
    }

    public Integer getBlockSize(int num) {
        if (this.blockIndices.containsKey(num)) {
            return this.blockIndices.get((Object)Integer.valueOf((int)num)).size;
        }
        return null;
    }

    public IndexEntry getBlock(int blockNumber) {
        return this.blockIndices.get(blockNumber);
    }

    public void clearCache() {
        this.blockIndices.clear();
    }
}

