/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javastraw.reader.block.ContactRecord;

public class Block
implements Comparable<Block> {
    private final int number;
    private final String uniqueRegionID;
    private final List<ContactRecord> records;

    public Block(int number, String regionID) {
        this.number = number;
        this.records = new ArrayList<ContactRecord>();
        this.uniqueRegionID = regionID + "_" + number;
    }

    public Block(int number, List<ContactRecord> records, String regionID) {
        this.number = number;
        this.records = records;
        this.uniqueRegionID = regionID + "_" + number;
    }

    public int getNumber() {
        return this.number;
    }

    public String getUniqueRegionID() {
        return this.uniqueRegionID;
    }

    public List<ContactRecord> getContactRecords() {
        return this.records;
    }

    public void clear() {
        this.records.clear();
    }

    @Override
    public int compareTo(Block o) {
        int[] comparisons;
        if (this == o) {
            return 0;
        }
        for (int val : comparisons = new int[]{Integer.compare(this.number, o.number), this.uniqueRegionID.compareTo(o.uniqueRegionID), Integer.compare(this.records.size(), o.records.size())}) {
            if (val == 0) continue;
            return val;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Block && ((Block)obj).number == this.number && ((Block)obj).uniqueRegionID.equals(this.uniqueRegionID) && ((Block)obj).records.size() == this.records.size();
    }

    public int hashCode() {
        return Objects.hash(this.number, this.uniqueRegionID, this.records.size());
    }
}

