/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.basics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.basics.ChromosomeArrayPair;
import javastraw.reader.basics.ChromosomeTools;

public class ChromosomeHandler {
    private static final String GENOMEWIDE_CHR = "GENOMEWIDE";
    private static final String CHR_ALL = "All";
    private final Map<String, Chromosome> chromosomeMap;
    private final List<Chromosome> cleanedChromosomes;
    private final String genomeID;
    private final long[] chromosomeBoundaries;
    private final Chromosome[] chromosomesArray;
    private final Chromosome[] chromosomeArrayWithoutAllByAll;
    private final Chromosome[] chromosomeArrayAutosomesOnly;

    public ChromosomeHandler(List<Chromosome> chromosomes, String genomeID, boolean inferID) {
        this(chromosomes, genomeID, inferID, true);
    }

    public ChromosomeHandler(List<Chromosome> chromosomes, String genomeID, boolean inferID, boolean createAllChr) {
        String inferGenomeId;
        this.genomeID = inferID ? ((inferGenomeId = this.inferGenomeId()) != null ? inferGenomeId : genomeID) : genomeID;
        if (createAllChr) {
            long genomeLength = this.getTotalLengthOfAllChromosomes(chromosomes);
            chromosomes.set(0, new Chromosome(0, this.cleanUpName(CHR_ALL), (int)(genomeLength / 1000L)));
        }
        this.cleanedChromosomes = this.initializeCleanedChromosomesList(chromosomes);
        this.chromosomeMap = ChromosomeHandler.initializeMapping(this.cleanedChromosomes);
        this.chromosomeBoundaries = ChromosomeHandler.initializeBoundaries(this.cleanedChromosomes);
        this.chromosomesArray = ChromosomeHandler.initializeInternalVariables(this.cleanedChromosomes);
        this.chromosomeArrayWithoutAllByAll = ChromosomeHandler.initializeWithoutAll(this.chromosomesArray);
        this.chromosomeArrayAutosomesOnly = ChromosomeHandler.initializeAutosomes(this.chromosomeArrayWithoutAllByAll);
    }

    public static boolean isAllByAll(String name) {
        return name.toLowerCase().contains("all");
    }

    public static void sort(List<Chromosome> indices) {
        indices.sort(new ChromosomeComparator());
    }

    private static Set<Chromosome> getSetIntersection(Collection<Chromosome> collection1, Collection<Chromosome> collection2) {
        HashSet<Chromosome> set1 = new HashSet<Chromosome>(collection1);
        HashSet<Chromosome> set2 = new HashSet<Chromosome>(collection2);
        boolean set1IsLarger = set1.size() > set2.size();
        HashSet<Chromosome> cloneSet = new HashSet<Chromosome>(set1IsLarger ? set2 : set1);
        cloneSet.retainAll(set1IsLarger ? set1 : set2);
        return cloneSet;
    }

    public static boolean isAllByAll(Chromosome chromosome) {
        return ChromosomeHandler.isAllByAll(chromosome.getName());
    }

    public String cleanUpName(String name) {
        if (this.genomeID.equalsIgnoreCase("hg19")) {
            return name.trim().toLowerCase().replaceAll("chr", "").toUpperCase();
        }
        return name;
    }

    private boolean isGenomeWide(Chromosome chromosome) {
        return this.isGenomeWide(chromosome.getName());
    }

    private boolean isGenomeWide(String name) {
        return this.cleanUpName(name).equalsIgnoreCase(GENOMEWIDE_CHR);
    }

    public Chromosome generateAssemblyChromosome() {
        int size = (int)this.getTotalLengthOfAllChromosomes(Arrays.asList(this.chromosomeArrayWithoutAllByAll));
        int newIndex = this.cleanedChromosomes.size();
        Chromosome newChr = new Chromosome(newIndex, "pseudoassembly", size);
        this.cleanedChromosomes.add(newChr);
        this.chromosomeMap.put(newChr.getName(), newChr);
        return newChr;
    }

    private List<Chromosome> initializeCleanedChromosomesList(List<Chromosome> chromosomes) {
        ArrayList<Chromosome> cleanedChromosomes = new ArrayList<Chromosome>();
        for (Chromosome c : chromosomes) {
            String cleanName = this.cleanUpName(c.getName());
            Chromosome cleanChromosome = new Chromosome(c.getIndex(), cleanName, c.getLength());
            cleanedChromosomes.add(cleanChromosome);
        }
        return cleanedChromosomes;
    }

    private static Map<String, Chromosome> initializeMapping(List<Chromosome> cleanedChromosomes) {
        HashMap<String, Chromosome> chromosomeMap = new HashMap<String, Chromosome>();
        for (Chromosome c : cleanedChromosomes) {
            chromosomeMap.put(c.getName(), c);
            if (!c.getName().equalsIgnoreCase("MT")) continue;
            chromosomeMap.put("M", c);
        }
        return chromosomeMap;
    }

    private static long[] initializeBoundaries(List<Chromosome> cleanedChromosomes) {
        long[] chromosomeBoundaries = new long[cleanedChromosomes.size() - 1];
        long bound = 0L;
        for (int i = 1; i < cleanedChromosomes.size(); ++i) {
            Chromosome c = cleanedChromosomes.get(i);
            chromosomeBoundaries[i - 1] = bound += c.getLength() / 1000L;
        }
        return chromosomeBoundaries;
    }

    private static Chromosome[] initializeInternalVariables(List<Chromosome> cleanedChromosomes) {
        return cleanedChromosomes.toArray(new Chromosome[0]);
    }

    private static Chromosome[] initializeWithoutAll(Chromosome[] chromosomesArray) {
        Chromosome[] chromosomeArrayWithoutAllByAll = new Chromosome[chromosomesArray.length - 1];
        System.arraycopy(chromosomesArray, 1, chromosomeArrayWithoutAllByAll, 0, chromosomesArray.length - 1);
        return chromosomeArrayWithoutAllByAll;
    }

    private static Chromosome[] initializeAutosomes(Chromosome[] chromosomeArrayWithoutAllByAll) {
        ArrayList<Chromosome> autosomes = new ArrayList<Chromosome>();
        for (Chromosome chr : chromosomeArrayWithoutAllByAll) {
            if (chr.getName().toLowerCase().contains("x") || chr.getName().toLowerCase().contains("y") || chr.getName().toLowerCase().contains("m")) continue;
            autosomes.add(chr);
        }
        Chromosome[] chromosomeArrayAutosomesOnly = new Chromosome[autosomes.size()];
        for (int i = 0; i < autosomes.size(); ++i) {
            chromosomeArrayAutosomesOnly[i] = (Chromosome)autosomes.get(i);
        }
        return chromosomeArrayAutosomesOnly;
    }

    private long getTotalLengthOfAllChromosomes(List<Chromosome> chromosomes) {
        long genomeLength = 0L;
        for (Chromosome c : chromosomes) {
            if (c == null) continue;
            genomeLength += c.getLength();
        }
        return genomeLength;
    }

    public String getGenomeID() {
        return this.genomeID;
    }

    public int getMaxChromIndex() {
        int maxChromIndex = 0;
        for (Chromosome chrom : this.chromosomesArray) {
            maxChromIndex = Math.max(maxChromIndex, chrom.getIndex());
        }
        return maxChromIndex;
    }

    public Chromosome getChromosomeFromName(String name) {
        return this.chromosomeMap.get(this.cleanUpName(name));
    }

    public boolean doesNotContainChromosome(String name) {
        return !this.chromosomeMap.containsKey(this.cleanUpName(name));
    }

    public int size() {
        return this.chromosomesArray.length;
    }

    public long[] getChromosomeBoundaries() {
        return this.chromosomeBoundaries;
    }

    public Chromosome[] getChromosomeArray() {
        return this.chromosomesArray;
    }

    public Chromosome getChromosomeFromIndex(int indx) {
        return this.chromosomesArray[indx];
    }

    public ChromosomeHandler getIntersectionWith(ChromosomeHandler handler2) {
        Set<Chromosome> intersection = ChromosomeHandler.getSetIntersection(this.cleanedChromosomes, handler2.cleanedChromosomes);
        if (intersection.isEmpty()) {
            return null;
        }
        ArrayList<Chromosome> newSetOfChrs = new ArrayList<Chromosome>();
        long genomeLength = this.getTotalLengthOfAllChromosomes(this.cleanedChromosomes);
        newSetOfChrs.add(new Chromosome(0, CHR_ALL, (int)(genomeLength / 1000L)));
        for (Chromosome chromosome : this.cleanedChromosomes) {
            if (ChromosomeHandler.isAllByAll(chromosome) || !intersection.contains(chromosome)) continue;
            newSetOfChrs.add(chromosome);
        }
        return new ChromosomeHandler(newSetOfChrs, this.genomeID, false);
    }

    public Chromosome[] getAutosomalChromosomesArray() {
        return this.chromosomeArrayAutosomesOnly;
    }

    public Chromosome[] getChromosomeArrayWithoutAllByAll() {
        return this.chromosomeArrayWithoutAllByAll;
    }

    public String inferGenomeId() {
        List<String> chrom_sizes = Arrays.asList("hg19", "hg38", "b37", "hg18", "mm10", "mm9", "GRCm38", "aedAeg1", "anasPlat1", "assembly", "bTaurus3", "calJac3", "canFam3", "capHir1", "dm3", "dMel", "EBV", "equCab2", "felCat8", "galGal4", "hg18", "loxAfr3", "macMul1", "macMulBaylor", "oryCun2", "oryLat2", "panTro4", "Pf3D7", "ratNor5", "ratNor6", "sacCer3", "sCerS288c", "spretus", "susScr3", "TAIR10");
        for (String id : chrom_sizes) {
            ChromosomeHandler handler = ChromosomeTools.loadChromosomes(id);
            for (Chromosome chr : handler.cleanedChromosomes) {
                for (Chromosome chr2 : this.cleanedChromosomes) {
                    if (chr.getName().equalsIgnoreCase("ALL") || !chr.getName().equals(chr2.getName()) || chr.getLength() != chr2.getLength()) continue;
                    return id;
                }
            }
        }
        return null;
    }

    public Chromosome[] extractOddOrEvenAutosomes(boolean extractOdd) {
        ArrayList<Chromosome> subset = new ArrayList<Chromosome>();
        for (Chromosome chromosome : this.chromosomeArrayAutosomesOnly) {
            if (extractOdd && chromosome.getIndex() % 2 == 1) {
                subset.add(chromosome);
                continue;
            }
            if (extractOdd || chromosome.getIndex() % 2 != 0) continue;
            subset.add(chromosome);
        }
        Chromosome[] subsetArray = new Chromosome[subset.size()];
        for (int i = 0; i < subset.size(); ++i) {
            subsetArray[i] = (Chromosome)subset.get(i);
        }
        return subsetArray;
    }

    public ChromosomeArrayPair splitAutosomesIntoHalves() {
        int n = this.chromosomeArrayAutosomesOnly.length;
        int autosomesLength = 0;
        for (Chromosome chrom : this.chromosomeArrayAutosomesOnly) {
            autosomesLength = (int)((long)autosomesLength + chrom.getLength());
        }
        int halfLength = autosomesLength / 2;
        int firstBatchUpToChr = n / 3 + 1;
        long prevLength = 0L;
        for (int i = 0; i < n / 2; ++i) {
            long newLength = prevLength + this.chromosomeArrayAutosomesOnly[i].getLength();
            if (prevLength <= (long)halfLength && newLength >= (long)halfLength) {
                if (Math.abs(prevLength - (long)halfLength) < Math.abs(newLength - (long)halfLength)) {
                    firstBatchUpToChr = i - 1;
                    break;
                }
                firstBatchUpToChr = i;
                break;
            }
            prevLength = newLength;
        }
        System.out.println("Splitting chromosomes; " + this.chromosomeArrayAutosomesOnly[0].getName() + " to " + this.chromosomeArrayAutosomesOnly[firstBatchUpToChr].getName() + " and " + this.chromosomeArrayAutosomesOnly[firstBatchUpToChr + 1].getName() + " to " + this.chromosomeArrayAutosomesOnly[n - 1].getName());
        Chromosome[] rowsChromosomes = new Chromosome[firstBatchUpToChr];
        Chromosome[] colsChromosomes = new Chromosome[n - firstBatchUpToChr];
        for (int i = 0; i < n; ++i) {
            if (i < firstBatchUpToChr) {
                rowsChromosomes[i] = this.chromosomeArrayAutosomesOnly[i];
                continue;
            }
            colsChromosomes[i - firstBatchUpToChr] = this.chromosomeArrayAutosomesOnly[i];
        }
        return new ChromosomeArrayPair(rowsChromosomes, colsChromosomes);
    }

    public ChromosomeArrayPair splitAutosomesAndSkipByTwos() {
        int n = this.chromosomeArrayAutosomesOnly.length;
        ArrayList<Chromosome> part1 = new ArrayList<Chromosome>();
        ArrayList<Chromosome> part2 = new ArrayList<Chromosome>();
        part1.add(this.chromosomeArrayAutosomesOnly[0]);
        int counterOffset = 0;
        boolean addToFirstOne = false;
        for (int i = 1; i < n; ++i) {
            if (addToFirstOne) {
                part1.add(this.chromosomeArrayAutosomesOnly[i]);
                continue;
            }
            part2.add(this.chromosomeArrayAutosomesOnly[i]);
            if (++counterOffset != 2) continue;
            addToFirstOne = !addToFirstOne;
            counterOffset = 0;
        }
        return new ChromosomeArrayPair(this.chromosomeListToArray(part1), this.chromosomeListToArray(part2));
    }

    private Chromosome[] chromosomeListToArray(List<Chromosome> chromosomes) {
        Chromosome[] array = new Chromosome[chromosomes.size()];
        for (int i = 0; i < chromosomes.size(); ++i) {
            array[i] = chromosomes.get(i);
        }
        return array;
    }

    static class ChromosomeComparator
    implements Comparator<Chromosome> {
        ChromosomeComparator() {
        }

        @Override
        public int compare(Chromosome a, Chromosome b) {
            Integer aIndx = a.getIndex();
            Integer bIndx = b.getIndex();
            return aIndx.compareTo(bIndx);
        }
    }
}

