/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader.basics;

import java.util.Arrays;
import java.util.Objects;
import javastraw.reader.basics.Chromosome;

public class ChromosomeArrayPair {
    public final Chromosome[] a;
    public final Chromosome[] b;

    public ChromosomeArrayPair(Chromosome[] a, Chromosome[] b) {
        this.a = a;
        this.b = b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ChromosomeArrayPair) {
            int i;
            ChromosomeArrayPair other = (ChromosomeArrayPair)o;
            if (this.a.length != other.a.length || this.b.length != other.b.length) {
                return false;
            }
            for (i = 0; i < this.a.length; ++i) {
                if (!this.notEqual(this.a[i], other.a[i])) continue;
                return false;
            }
            for (i = 0; i < this.b.length; ++i) {
                if (!this.notEqual(this.b[i], other.b[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean notEqual(Chromosome c, Chromosome d) {
        boolean areEqual = c.getName().equalsIgnoreCase(d.getName()) && c.getIndex() == d.getIndex() && c.getLength() == d.getLength();
        return !areEqual;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.a), Arrays.hashCode(this.b));
    }
}

