/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javastraw.reader.DatasetReader;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.BlockIndices;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.block.DynamicBlockIndices;
import javastraw.reader.block.IndexEntry;
import javastraw.reader.block.LargeIndexEntry;
import javastraw.reader.datastructures.ListOfDoubleArrays;
import javastraw.reader.expected.ExpectedValueFunction;
import javastraw.reader.expected.ExpectedValueFunctionImpl;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.norm.NormFactorMapReader;
import javastraw.reader.norm.NormalizationVector;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;
import org.broad.igv.util.CompressionUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class ReaderTools {
    private static final int dynamicResolutionLimit = 50;
    private static final IGVSeekableStreamFactory streamFactory = IGVSeekableStreamFactory.getInstance();
    private static final int maxLengthEntryName = 100;
    private static final int MAX_BYTE_READ_SIZE = 0x7FFFFFF5;

    public static SeekableStream getValidStream(String path) throws IOException {
        SeekableStream stream;
        while ((stream = streamFactory.getStreamFor(path)) == null) {
        }
        return stream;
    }

    public static SeekableStream getValidStream(String path, long position) throws IOException {
        SeekableStream stream = ReaderTools.getValidStream(path);
        stream.seek(position);
        return stream;
    }

    public static LittleEndianInputStream createStreamFromSeveralBuffers(LargeIndexEntry idx, String path) throws IOException {
        List<byte[]> buffer = ReaderTools.seekAndFullyReadLargeCompressedBytes(idx, path);
        ArrayList<ByteArrayInputStream> disList = new ArrayList<ByteArrayInputStream>();
        for (int i = 0; i < buffer.size(); ++i) {
            disList.add(new ByteArrayInputStream(buffer.get(i)));
        }
        return new LittleEndianInputStream(new SequenceInputStream(Collections.enumeration(disList)));
    }

    public static byte[] seekAndFullyReadCompressedBytes(IndexEntry idx, String path) throws IOException {
        byte[] compressedBytes = new byte[idx.size];
        SeekableStream stream = ReaderTools.getValidStream(path, idx.position);
        stream.readFully(compressedBytes);
        stream.close();
        return compressedBytes;
    }

    public static List<byte[]> seekAndFullyReadLargeCompressedBytes(LargeIndexEntry idx, String path) throws IOException {
        long counter;
        ArrayList<byte[]> compressedBytes = new ArrayList<byte[]>();
        for (counter = idx.size; counter > 0x7FFFFFF5L; counter -= 0x7FFFFFF5L) {
            compressedBytes.add(new byte[0x7FFFFFF5]);
        }
        compressedBytes.add(new byte[(int)counter]);
        SeekableStream stream = ReaderTools.getValidStream(path, idx.position);
        for (int i = 0; i < compressedBytes.size(); ++i) {
            stream.readFully((byte[])compressedBytes.get(i));
        }
        stream.close();
        return compressedBytes;
    }

    public static MatrixZoomData readMatrixZoomData(Chromosome chr1, Chromosome chr2, int[] chr1Sites, int[] chr2Sites, long filePointer, String path, boolean useCache, DatasetReader reader, int specificResolution, boolean allowDynamicBlockIndex, long[] storeFilePosition) throws IOException {
        BlockIndices blockIndices;
        int maxPossibleBlockNumber;
        SeekableStream stream = ReaderTools.getValidStream(path, filePointer);
        LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(stream, 0x200000));
        String hicUnitStr = dis.readString();
        HiCZoom.HiCUnit unit = HiCZoom.valueOfUnit(hicUnitStr);
        dis.readInt();
        double sumCounts = dis.readFloat();
        float occupiedCellCount = dis.readFloat();
        float stdDev = dis.readFloat();
        float percent95 = dis.readFloat();
        int binSize = dis.readInt();
        HiCZoom zoom = new HiCZoom(unit, binSize);
        int blockBinCount = dis.readInt();
        int blockColumnCount = dis.readInt();
        int nBlocks = dis.readInt();
        long currentFilePointer = filePointer + 36L + (long)hicUnitStr.getBytes().length + 1L;
        if (specificResolution > 0) {
            if (binSize != specificResolution) {
                maxPossibleBlockNumber = blockColumnCount * blockColumnCount - 1;
                blockIndices = new DynamicBlockIndices(ReaderTools.getValidStream(path), nBlocks, maxPossibleBlockNumber, currentFilePointer);
            } else {
                blockIndices = new BlockIndices(nBlocks);
                blockIndices.populateBlocks(dis);
            }
        } else if (allowDynamicBlockIndex && binSize < 50) {
            maxPossibleBlockNumber = blockColumnCount * blockColumnCount - 1;
            blockIndices = new DynamicBlockIndices(ReaderTools.getValidStream(path), nBlocks, maxPossibleBlockNumber, currentFilePointer);
        } else {
            blockIndices = new BlockIndices(nBlocks);
            blockIndices.populateBlocks(dis);
        }
        MatrixZoomData zd = new MatrixZoomData(chr1, chr2, zoom, blockBinCount, blockColumnCount, chr1Sites, chr2Sites, reader, blockIndices, useCache, sumCounts);
        stream.close();
        storeFilePosition[0] = currentFilePointer += (long)nBlocks * 16L;
        return zd;
    }

    public static long readExpectedVectorInFooter(long currentPosition, Map<String, ExpectedValueFunction> expectedValuesMap, NormalizationType norm, int version, String path, DatasetReader reader) throws IOException {
        SeekableStream stream = ReaderTools.getValidStream(path, currentPosition);
        LittleEndianInputStream dis = new LittleEndianInputStream(new BufferedInputStream(stream, 50));
        String unitString = dis.readString();
        currentPosition += (long)(unitString.length() + 1);
        HiCZoom.HiCUnit unit = HiCZoom.valueOfUnit(unitString);
        int binSize = dis.readInt();
        currentPosition += 4L;
        long[] nValues = new long[1];
        currentPosition += ReaderTools.readVectorLength(dis, nValues, version);
        currentPosition = ReaderTools.setUpPartialVectorStreaming(currentPosition, expectedValuesMap, unit, binSize, nValues[0], norm, version, path, reader);
        stream.close();
        return currentPosition;
    }

    public static long readVectorLength(LittleEndianInputStream dis, long[] nValues, int version) throws IOException {
        if (version > 8) {
            nValues[0] = dis.readLong();
            return 8L;
        }
        nValues[0] = dis.readInt();
        return 4L;
    }

    public static long setUpPartialVectorStreaming(long currentPosition, Map<String, ExpectedValueFunction> expectedValuesMap, HiCZoom.HiCUnit unit, int binSize, long nValues, NormalizationType norm, int version, String path, DatasetReader reader) throws IOException {
        long skipPosition = currentPosition;
        long expectedVectorIndexPosition = currentPosition;
        skipPosition = version > 8 ? (skipPosition += nValues * 4L) : (skipPosition += nValues * 8L);
        SeekableStream stream = ReaderTools.getValidStream(path, skipPosition);
        int nNormalizationFactors = ReaderTools.readIntFromBytes(stream);
        currentPosition = skipPosition + 4L;
        if (nNormalizationFactors > 0) {
            NormFactorMapReader hmReader = new NormFactorMapReader(nNormalizationFactors, version, currentPosition, path);
            currentPosition += (long)hmReader.getOffset();
            ExpectedValueFunctionImpl df = new ExpectedValueFunctionImpl(norm, unit, binSize, nValues, expectedVectorIndexPosition, hmReader.getNormFactors(), reader);
            String key = ExpectedValueFunction.getKey(unit, binSize, norm);
            expectedValuesMap.put(key, df);
        }
        stream.close();
        return currentPosition;
    }

    public static long readVectorOfFloats(LittleEndianInputStream dis, long nValues, ListOfDoubleArrays values2) throws IOException {
        for (long j = 0L; j < nValues; ++j) {
            values2.set(j, dis.readFloat());
        }
        return 4L * nValues;
    }

    public static long readVectorOfDoubles(LittleEndianInputStream dis, long nValues, ListOfDoubleArrays values2) throws IOException {
        for (long j = 0L; j < nValues; ++j) {
            values2.set(j, dis.readDouble());
        }
        return 8L * nValues;
    }

    public static NormalizationVector createNormalizationVector(NormalizationType type, int chrIdx, HiCZoom.HiCUnit unit, int binSize, boolean useVCForVCSQRT, LittleEndianInputStream dis, long nValues, int version) throws IOException {
        ListOfDoubleArrays values2 = new ListOfDoubleArrays(nValues);
        boolean allNaN = true;
        for (long i = 0L; i < nValues; ++i) {
            double val;
            double d = val = version > 8 ? (double)dis.readFloat() : dis.readDouble();
            if (!useVCForVCSQRT) {
                values2.set(i, val);
            } else {
                values2.set(i, Math.sqrt(val));
            }
            if (Double.isNaN(val)) continue;
            allNaN = false;
        }
        if (allNaN) {
            return null;
        }
        return new NormalizationVector(type, chrIdx, unit, binSize, values2);
    }

    public static void populateContactRecordsColShort(LittleEndianInputStream dis, List<ContactRecord> records, int binXOffset, boolean useShort, int binY) throws IOException {
        int colCount = dis.readShort();
        for (int j = 0; j < colCount; ++j) {
            int binX = binXOffset + dis.readShort();
            float counts = useShort ? (float)dis.readShort() : dis.readFloat();
            records.add(new ContactRecord(binX, binY, counts));
        }
    }

    public static void populateContactRecordsColInt(LittleEndianInputStream dis, List<ContactRecord> records, int binXOffset, boolean useShort, int binY) throws IOException {
        int colCount = dis.readInt();
        for (int j = 0; j < colCount; ++j) {
            int binX = binXOffset + dis.readInt();
            float counts = useShort ? (float)dis.readShort() : dis.readFloat();
            records.add(new ContactRecord(binX, binY, counts));
        }
    }

    public static byte[] decompress(byte[] compressedBytes) {
        CompressionUtils compressionUtils = new CompressionUtils();
        return compressionUtils.decompress(compressedBytes);
    }

    public static int[] readSites(long position, int nSites, String path) throws IOException {
        IndexEntry idx = new IndexEntry(position, 4 + nSites * 4);
        byte[] buffer = ReaderTools.seekAndFullyReadCompressedBytes(idx, path);
        LittleEndianInputStream les = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
        int[] sites = new int[nSites];
        for (int s = 0; s < nSites; ++s) {
            sites[s] = les.readInt();
        }
        return sites;
    }

    public static int readIntFromBytes(SeekableStream stream) throws IOException {
        byte[] buffer = new byte[4];
        int actualBytes = stream.read(buffer);
        if (actualBytes == 4) {
            LittleEndianInputStream dis = new LittleEndianInputStream(new ByteArrayInputStream(buffer));
            return dis.readInt();
        }
        System.err.println("Actually read " + actualBytes + " bytes instead of " + 4);
        System.exit(110);
        return 0;
    }
}

