/*
 * Decompiled with CFR 0.152.
 */
package javastraw.reader;

import htsjdk.samtools.seekablestream.SeekableHTTPStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.tribble.util.LittleEndianInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import javastraw.reader.DatasetReaderV2;

public class DatasetReaderFactory {
    public static DatasetReaderV2 getReaderForFile(String file, boolean useCache, boolean useDynamicBlockIndex) throws IOException {
        String magicString = DatasetReaderFactory.getMagicString(file);
        if (magicString != null) {
            if (magicString.equals("HIC")) {
                return new DatasetReaderV2(file, useCache, useDynamicBlockIndex);
            }
            System.err.println("This version is deprecated and is no longer supported.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMagicString(String path) throws IOException {
        LittleEndianInputStream dis = null;
        try (SeekableStream stream = null;){
            stream = new SeekableHTTPStream(new URL(path));
            dis = new LittleEndianInputStream(new BufferedInputStream(stream));
        }
        if (dis != null) {
            return dis.readString();
        }
        return null;
    }
}

