/*
 * Decompiled with CFR 0.152.
 */
package javastraw.igv;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;

public class ParsingUtils {
    public static BufferedReader openBufferedReader(String pathOrUrl) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(ParsingUtils.openInputStream(pathOrUrl)));
        return reader;
    }

    public static InputStream openInputStream(String path) throws IOException {
        return ParsingUtils.openInputStreamGZ(new ResourceLocator(path));
    }

    public static InputStream openInputStreamGZ(ResourceLocator locator) throws IOException {
        InputStream inputStream = null;
        if (ParsingUtils.isDataURL(locator.getPath())) {
            String dataURL = locator.getPath();
            int commaIndex = dataURL.indexOf(44);
            if (commaIndex < 0) {
                throw new Error("dataURL missing commas");
            }
            String contents = URLDecoder.decode(dataURL.substring(commaIndex + 1), String.valueOf(StandardCharsets.UTF_8));
            return new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
        }
        if (HttpUtils.isRemoteURL(locator.getPath())) {
            URL url = HttpUtils.createURL(locator.getPath());
            inputStream = HttpUtils.getInstance().openConnectionStream(url);
        } else {
            String path = locator.getPath();
            if (path.startsWith("file://")) {
                path = path.substring(7);
            }
            File file = new File(path);
            inputStream = new FileInputStream(file);
        }
        if (locator.getPath().endsWith("gz")) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static boolean isDataURL(String url) {
        return url != null && url.startsWith("data:") && !new File(url).exists();
    }
}

