/*
 * Decompiled with CFR 0.152.
 */
package javastraw.expected;

import javastraw.expected.ZScoreArray;

public class WelfordArray {
    private final long[] counts;
    private final double[] mu;
    private final double[] aggSquaredDiffs;

    public WelfordArray(int n) {
        this.counts = new long[n];
        this.mu = new double[n];
        this.aggSquaredDiffs = new double[n];
    }

    public void addValue(int i, double x) {
        int n = i;
        this.counts[n] = this.counts[n] + 1L;
        double nextMu = this.mu[i] + (x - this.mu[i]) / (double)this.counts[i];
        int n2 = i;
        this.aggSquaredDiffs[n2] = this.aggSquaredDiffs[n2] + (x - this.mu[i]) * (x - nextMu);
        this.mu[i] = nextMu;
    }

    public double[] getMean() {
        return this.mu;
    }

    public double[] getStdDev() {
        double[] std = new double[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] <= 2L) continue;
            std[i] = Math.sqrt(this.aggSquaredDiffs[i] / (double)(this.counts[i] - 1L));
        }
        return std;
    }

    public ZScoreArray getZscores() {
        return new ZScoreArray(this.getMean(), this.getStdDev());
    }
}

