/*
 * Decompiled with CFR 0.152.
 */
package javastraw.expected;

import javastraw.expected.Zscore;

public class Welford {
    private long counts = 0L;
    private double mu = 0.0;
    private double aggSquaredDiffs = 0.0;
    private double min = Double.MAX_VALUE;
    private double max = 0.0;

    public void addValue(double x) {
        ++this.counts;
        double nextMu = this.mu + (x - this.mu) / (double)this.counts;
        this.aggSquaredDiffs += (x - this.mu) * (x - nextMu);
        this.mu = nextMu;
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
    }

    public double getMean() {
        return this.mu;
    }

    public double getStdDev() {
        if (this.counts > 2L) {
            return Math.sqrt(this.aggSquaredDiffs / (double)(this.counts - 1L));
        }
        return 0.0;
    }

    public double getRange() {
        return this.max - this.min;
    }

    public Zscore getZscore() {
        return new Zscore(this.getMean(), this.getStdDev());
    }

    public long getCounts() {
        return this.counts;
    }

    public void addZeroIfBelow(int length) {
        int numToAdd = (int)((long)length - this.counts);
        for (int z = 0; z < numToAdd; ++z) {
            this.addValue(0.0);
        }
    }

    public String getSummary() {
        return " mu " + this.getMean() + " sigma " + this.getStdDev() + " min " + this.min + " max " + this.max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

