/*
 * Decompiled with CFR 0.152.
 */
package javastraw.expected;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javastraw.expected.ExpectedModel;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.NormalizationType;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class LogExpectedSpline
extends ExpectedModel {
    private static final int minValsInFinalBins = 100;
    private final PolynomialSplineFunction function;
    private final double nearDiagonalSignal;
    private final float maxX;

    public LogExpectedSpline(MatrixZoomData zd, NormalizationType norm, Chromosome chrom, int res) {
        int maxBin = (int)(chrom.getLength() / (long)res + 1L);
        int[] maxDist = new int[1];
        this.function = this.fitDataToFunction(zd, norm, maxBin, maxDist);
        this.maxX = this.logp1i(Math.min(maxBin, maxDist[0]));
        this.nearDiagonalSignal = Math.expm1(this.function.value(0.5));
    }

    private PolynomialSplineFunction fitDataToFunction(MatrixZoomData zd, NormalizationType norm, int maxBin, int[] maxDist) {
        List<double[]> points = this.getAverageInEachBin(zd, norm, maxBin, maxDist);
        double[] x = new double[points.size()];
        double[] y = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            x[i] = points.get(i)[0];
            y[i] = points.get(i)[1];
        }
        points.clear();
        SplineInterpolator interpolator = new SplineInterpolator();
        return interpolator.interpolate(x, y);
    }

    private List<double[]> getAverageInEachBin(MatrixZoomData zd, NormalizationType norm, int maxBin, int[] maxDist) {
        double[] initExpected = new double[maxBin];
        long[] countsPerBin = new long[maxBin];
        this.populateWithCounts(zd, norm, initExpected, countsPerBin, maxBin, maxDist);
        int maxDistToUse = Math.min(maxBin, maxDist[0]);
        List<double[]> currentPoints = this.collapseToSetOfPoints(initExpected, countsPerBin, maxDistToUse);
        ArrayList<double[]> finalPoints = new ArrayList<double[]>(currentPoints.size());
        initExpected = null;
        countsPerBin = null;
        for (double[] current : currentPoints) {
            if (!(current[3] > 0.0) || !(current[1] > 0.0)) continue;
            double[] finalPoint = new double[]{current[2] / current[3], current[0] / current[1]};
            finalPoints.add(finalPoint);
        }
        currentPoints.clear();
        return finalPoints;
    }

    private List<double[]> collapseToSetOfPoints(double[] initExpected, long[] countsPerBin, int maxBin) {
        int k;
        LinkedList<double[]> points = new LinkedList<double[]>();
        double[] latest = new double[4];
        int numToGroup = 1;
        for (k = 0; k < initExpected.length; ++k) {
            latest[0] = latest[0] + initExpected[k];
            latest[1] = latest[1] + (double)countsPerBin[k];
            latest[2] = latest[2] + LogExpectedSpline.logp1(k);
            latest[3] = latest[3] + 1.0;
            if (latest[3] != (double)numToGroup) continue;
            points.add(latest);
            latest = new double[4];
            if (points.size() % 10 != 0) continue;
            numToGroup *= 5;
        }
        if (latest[3] > 10.0 && latest[1] > 100.0) {
            points.add(latest);
        }
        latest = new double[4];
        for (k = (int)(0.75 * (double)maxBin); k < maxBin; ++k) {
            latest[0] = latest[0] + initExpected[k];
            latest[1] = latest[1] + (double)countsPerBin[k];
        }
        latest[2] = LogExpectedSpline.logp1(maxBin) + 1.0;
        latest[3] = 1.0;
        points.add(latest);
        return points;
    }

    private void populateWithCounts(MatrixZoomData zd, NormalizationType norm, double[] initExpected, long[] countsPerBin, int maxBin, int[] maxDist) {
        Iterator<ContactRecord> records = LogExpectedSpline.getIterator(zd, norm);
        while (records.hasNext()) {
            ContactRecord record = records.next();
            int dist = LogExpectedSpline.getDist(record);
            if (dist >= maxBin) continue;
            maxDist[0] = Math.max(maxDist[0], dist);
            int n = dist;
            initExpected[n] = initExpected[n] + LogExpectedSpline.logp1(record.getCounts());
            int n2 = dist;
            countsPerBin[n2] = countsPerBin[n2] + 1L;
        }
    }

    @Override
    public double getExpectedFromUncompressedBin(int dist0) {
        double dist = Math.max(0.0, LogExpectedSpline.logp1(dist0));
        dist = Math.min(dist, (double)this.maxX);
        return Math.expm1(this.function.value(dist));
    }

    @Override
    public double getNearDiagonalSignal() {
        return this.nearDiagonalSignal;
    }
}

