/*
 * Decompiled with CFR 0.152.
 */
package javastraw.expected;

import java.util.Iterator;
import javastraw.feature2D.Feature2D;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.NormalizationType;

public class ExpectedUtils {
    public static double[] calculateExpected(MatrixZoomData zd, NormalizationType norm, int maxBinDist, boolean useLog) {
        double[] expected = new double[maxBinDist];
        long[] counts = new long[maxBinDist];
        Iterator<ContactRecord> iterator2 = zd.getNormalizedIterator(norm);
        ExpectedUtils.updateExpectedAndCounts(maxBinDist, useLog, expected, counts, iterator2);
        ExpectedUtils.normalizeByCounts(expected, counts);
        if (useLog) {
            ExpectedUtils.expm1(expected);
        }
        return expected;
    }

    private static void normalizeByCounts(double[] vector, long[] counts) {
        for (int z = 0; z < vector.length; ++z) {
            if (counts[z] <= 0L) continue;
            int n = z;
            vector[n] = vector[n] / (double)counts[z];
        }
    }

    private static void expm1(double[] vector) {
        for (int z = 0; z < vector.length; ++z) {
            vector[z] = Math.expm1(vector[z]);
        }
    }

    private static void updateExpectedAndCounts(int maxBinDist, boolean useLog, double[] expected, long[] counts, Iterator<ContactRecord> iterator2) {
        while (iterator2.hasNext()) {
            ContactRecord record = iterator2.next();
            int dist = ExpectedUtils.getDist(record);
            if (dist >= maxBinDist) continue;
            if (useLog) {
                int n = dist;
                expected[n] = expected[n] + Math.log(1.0f + record.getCounts());
            } else {
                int n = dist;
                expected[n] = expected[n] + (double)record.getCounts();
            }
            int n = dist;
            counts[n] = counts[n] + 1L;
        }
    }

    public static int getDist(Feature2D loop, int resolution) {
        int binXStart = (int)(loop.getMidPt1() / (long)resolution);
        int binYStart = (int)(loop.getMidPt2() / (long)resolution);
        return Math.abs(binXStart - binYStart);
    }

    public static int getDist(ContactRecord record) {
        return Math.abs(record.getBinX() - record.getBinY());
    }

    public static Iterator<ContactRecord> getIterator(MatrixZoomData zd, NormalizationType norm) {
        if (norm.getLabel().equalsIgnoreCase("none")) {
            return zd.getDirectIterator();
        }
        return zd.getNormalizedIterator(norm);
    }
}

