/*
 * Decompiled with CFR 0.152.
 */
package javastraw.expected;

import java.util.Iterator;
import javastraw.expected.ExpectedUtils;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.type.NormalizationType;

public abstract class ExpectedModel {
    public static int getDist(ContactRecord record) {
        return Math.abs(record.getBinX() - record.getBinY());
    }

    public static Iterator<ContactRecord> getIterator(MatrixZoomData zd, NormalizationType norm) {
        if (norm.getLabel().equalsIgnoreCase("none")) {
            return zd.getDirectIterator();
        }
        return zd.getNormalizedIterator(norm);
    }

    public static float getP(double obs, double expected, double superDiagonal) {
        return (float)((obs - expected) / (superDiagonal - expected));
    }

    public static double logp1(double x) {
        return Math.log(1.0 + x);
    }

    public abstract double getExpectedFromUncompressedBin(int var1);

    public abstract double getNearDiagonalSignal();

    public float getPercentContact(ContactRecord cr) {
        return this.getPercentContact(ExpectedUtils.getDist(cr), cr.getCounts());
    }

    public float getPercentContact(int dist, float counts) {
        double baseline = this.getExpectedFromUncompressedBin(dist);
        return ExpectedModel.getP(counts, baseline, this.getNearDiagonalSignal());
    }

    public double[] expm1(double[] input) {
        double[] vec = new double[input.length];
        for (int k = 0; k < vec.length; ++k) {
            vec[k] = Math.expm1(input[k]);
        }
        return vec;
    }

    public int logp1i(int x) {
        return (int)Math.log(1 + x);
    }

    public boolean isReasonablePercentContact(ContactRecord cr, float minPC, float maxPC) {
        float percentContact = this.getPercentContact(cr);
        return percentContact > minPC && percentContact < maxPC;
    }

    public boolean isReasonableEnrichment(ContactRecord cr, float enrichmentVSExpected) {
        return (double)cr.getCounts() / this.getExpectedFromUncompressedBin(ExpectedUtils.getDist(cr)) > (double)enrichmentVSExpected;
    }

    public void print(int maxBin) {
        for (int k = 0; k < maxBin; ++k) {
            System.out.println(k + "  " + this.getExpectedFromUncompressedBin(k));
        }
    }
}

