/*
 * Decompiled with CFR 0.152.
 */
package javastraw;

import java.util.Iterator;
import java.util.List;
import javastraw.reader.Dataset;
import javastraw.reader.basics.Chromosome;
import javastraw.reader.block.Block;
import javastraw.reader.block.ContactRecord;
import javastraw.reader.mzd.Matrix;
import javastraw.reader.mzd.MatrixZoomData;
import javastraw.reader.norm.NormalizationPicker;
import javastraw.reader.type.HiCZoom;
import javastraw.reader.type.NormalizationType;
import javastraw.tools.HiCFileTools;

public class AnnotatedExample {
    public static void main(String[] args) {
        Chromosome[] chromosomes;
        boolean useCache = false;
        String filename = "file.hic";
        Dataset ds = HiCFileTools.extractDatasetForCLT(filename, false, useCache, false);
        NormalizationType norm = NormalizationPicker.getFirstValidNormInThisOrder(ds, new String[]{"KR", "SCALE", "VC", "VC_SQRT", "NONE"});
        System.out.println("Norm being used: " + norm.getLabel());
        int resolution = 5000;
        for (Chromosome chromosome : chromosomes = ds.getChromosomeHandler().getChromosomeArrayWithoutAllByAll()) {
            MatrixZoomData zd;
            Matrix matrix = ds.getMatrix(chromosome, chromosome);
            if (matrix == null || (zd = matrix.getZoomData(new HiCZoom(resolution))) == null) continue;
            Iterator<ContactRecord> iterator2 = zd.getNormalizedIterator(norm);
            while (iterator2.hasNext()) {
                ContactRecord record = iterator2.next();
                int binX = record.getBinX();
                int binY = record.getBinY();
                float counts = record.getCounts();
                int genomeX = binX * resolution;
                int genomeY = binY * resolution;
                if (!(counts > 0.0f)) continue;
                System.out.println(genomeX + " " + genomeY + " " + counts);
                if (binX == binY) continue;
                binX = record.getBinY();
                binY = record.getBinX();
                counts = record.getCounts();
                genomeX = binX * resolution;
                genomeY = binY * resolution;
                System.out.println(genomeX + " " + genomeY + " " + counts);
            }
            boolean getDataUnderTheDiagonal = true;
            int binXStart = 500;
            int binYStart = 600;
            int binXEnd = 1000;
            int binYEnd = 1200;
            List<Block> blocks = zd.getNormalizedBlocksOverlapping(binXStart, binYStart, binXEnd, binYEnd, norm, getDataUnderTheDiagonal);
            for (Block b : blocks) {
                if (b == null) continue;
                for (ContactRecord rec : b.getContactRecords()) {
                    if (!(rec.getCounts() > 0.0f)) continue;
                    int binX = rec.getBinX();
                    int binY = rec.getBinY();
                    int relativeX = rec.getBinX() - binXStart;
                    int relativeY = rec.getBinY() - binYStart;
                    float f = rec.getCounts();
                }
            }
        }
        for (int i = 0; i < chromosomes.length; ++i) {
            int j = i;
            while (i < chromosomes.length) {
                MatrixZoomData zd;
                Matrix matrix = ds.getMatrix(chromosomes[i], chromosomes[j]);
                if (matrix == null || (zd = matrix.getZoomData(new HiCZoom(resolution))) == null || i == j) {
                    // empty if block
                }
                ++i;
            }
        }
    }
}

