/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext.filter;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.filter.VariantContextFilter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FilteringVariantContextIterator
implements CloseableIterator<VariantContext>,
Iterable<VariantContext> {
    private final Iterator<VariantContext> iterator;
    private final VariantContextFilter filter;
    private VariantContext next = null;

    public FilteringVariantContextIterator(Iterator<VariantContext> iterator2, VariantContextFilter filter) {
        this.iterator = iterator2;
        this.filter = filter;
        this.next = this.getNextVC();
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public VariantContext next() throws NoSuchElementException {
        if (this.next == null) {
            throw new NoSuchElementException("Iterator has no more elements.");
        }
        VariantContext result = this.next;
        this.next = this.getNextVC();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove() not supported by FilteringVariantContextIterator");
    }

    private VariantContext getNextVC() {
        while (this.iterator.hasNext()) {
            VariantContext record = this.iterator.next();
            if (!this.filter.test(record)) continue;
            return record;
        }
        return null;
    }

    @Override
    public Iterator<VariantContext> iterator() {
        return this;
    }
}

