/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import java.util.List;
import java.util.Map;

public final class FastGenotype
extends Genotype {
    private final List<Allele> alleles;
    private final boolean isPhased;
    private final int GQ;
    private final int DP;
    private final int[] AD;
    private final int[] PL;
    private final Map<String, Object> extendedAttributes;

    protected FastGenotype(String sampleName, List<Allele> alleles, boolean isPhased, int GQ, int DP, int[] AD, int[] PL, String filters, Map<String, Object> extendedAttributes) {
        super(sampleName, filters);
        this.alleles = alleles;
        this.isPhased = isPhased;
        this.GQ = GQ;
        this.DP = DP;
        this.AD = AD;
        this.PL = PL;
        this.extendedAttributes = extendedAttributes;
    }

    @Override
    public List<Allele> getAlleles() {
        return this.alleles;
    }

    @Override
    public Allele getAllele(int i) {
        return this.alleles.get(i);
    }

    @Override
    public boolean isPhased() {
        return this.isPhased;
    }

    @Override
    public int getDP() {
        return this.DP;
    }

    @Override
    public int[] getAD() {
        return this.AD;
    }

    @Override
    public int getGQ() {
        return this.GQ;
    }

    @Override
    public int[] getPL() {
        return this.PL;
    }

    @Override
    public Map<String, Object> getExtendedAttributes() {
        return this.extendedAttributes;
    }

    private static boolean validADorPLField(int[] values2) {
        if (values2 != null) {
            for (int v : values2) {
                if (v >= 0) continue;
                return false;
            }
        }
        return true;
    }
}

