/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekableIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;

public class MergingIterator<T>
implements CloseableIterator<T> {
    private final PriorityQueue<ComparableIterator> queue;
    private final Comparator<T> comparator;
    private T lastReturned;

    public MergingIterator(Comparator<T> comparator, Collection<CloseableIterator<T>> iterators) {
        if (iterators.isEmpty()) {
            throw new IllegalArgumentException("One or more CloseableIterators must be provided.");
        }
        this.comparator = comparator;
        this.queue = new PriorityQueue();
        for (CloseableIterator<T> iterator2 : iterators) {
            this.addIfNotEmpty(new ComparableIterator(iterator2));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ComparableIterator recordIterator = this.queue.poll();
        Object next = recordIterator.next();
        if (this.lastReturned != null && this.comparator.compare(this.lastReturned, next) > 0) {
            throw new IllegalStateException("The elements of the input Iterators are not sorted according to the comparator " + this.comparator.getClass().getName());
        }
        this.addIfNotEmpty(recordIterator);
        this.lastReturned = next;
        return (T)next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        Iterator<ComparableIterator> iterator2 = this.queue.iterator();
        while (iterator2.hasNext()) {
            ComparableIterator subIterator = iterator2.next();
            subIterator.close();
            iterator2.remove();
        }
    }

    private void addIfNotEmpty(ComparableIterator iterator2) {
        if (iterator2.hasNext()) {
            this.queue.offer(iterator2);
        } else {
            iterator2.close();
        }
    }

    private class ComparableIterator
    extends PeekableIterator<T>
    implements Comparable<ComparableIterator> {
        public ComparableIterator(Iterator<T> iterator2) {
            super(iterator2);
        }

        @Override
        public int compareTo(ComparableIterator that) {
            if (MergingIterator.this.comparator.getClass() != MergingIterator.this.comparator.getClass()) {
                throw new IllegalStateException("Can't compare two ComparableIterators that have different orderings.");
            }
            return MergingIterator.this.comparator.compare(this.peek(), that.peek());
        }
    }
}

