/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman.codec;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.huffman.codec.CanonicalHuffmanByteCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class HuffmanByteEncoding
implements Encoding<Byte> {
    private static final EncodingID ENCODING_ID = EncodingID.HUFFMAN;
    private int[] bitLengths;
    private byte[] values;
    private ByteBuffer buf = ByteBuffer.allocate(1024);

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        if (this.buf.capacity() < this.values.length * 8) {
            this.buf = ByteBuffer.allocate(this.values.length * 8);
        }
        ITF8.writeUnsignedITF8((int)this.values.length, (ByteBuffer)this.buf);
        for (int value : this.values) {
            this.buf.put((byte)value);
        }
        ITF8.writeUnsignedITF8((int)this.bitLengths.length, (ByteBuffer)this.buf);
        for (int value : this.bitLengths) {
            ITF8.writeUnsignedITF8((int)value, (ByteBuffer)this.buf);
        }
        this.buf.flip();
        byte[] byArray = new byte[this.buf.limit()];
        this.buf.get(byArray);
        return byArray;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        int size = ITF8.readUnsignedITF8(buf);
        this.values = new byte[size];
        buf.get(this.values);
        size = ITF8.readUnsignedITF8(buf);
        this.bitLengths = new int[size];
        for (int i = 0; i < size; ++i) {
            this.bitLengths[i] = ITF8.readUnsignedITF8(buf);
        }
    }

    @Override
    public BitCodec<Byte> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new CanonicalHuffmanByteCodec(this.values, this.bitLengths);
    }

    public static EncodingParams toParam(byte[] bfValues, int[] bfBitLens) {
        HuffmanByteEncoding e = new HuffmanByteEncoding();
        e.values = bfValues;
        e.bitLengths = bfBitLens;
        return new EncodingParams(ENCODING_ID, e.toByteArray());
    }
}

