/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.huffmanUtils;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanCode;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class HuffmanParamsCalculator {
    private final HashMap<Integer, MutableInt> countMap = new HashMap();
    private int[] values = new int[0];
    private int[] bitLens = new int[0];

    public void add(int value) {
        MutableInt counter = this.countMap.get(value);
        if (counter == null) {
            counter = new MutableInt();
            this.countMap.put(value, counter);
        }
        ++counter.value;
    }

    public void add(Integer value, int inc) {
        MutableInt counter = this.countMap.get(value);
        if (counter == null) {
            counter = new MutableInt();
            this.countMap.put(value, counter);
        }
        counter.value += inc;
    }

    public int[] bitLens() {
        return this.bitLens;
    }

    public int[] values() {
        return this.values;
    }

    public Integer[] valuesAsAutoIntegers() {
        Integer[] intValues = new Integer[this.values.length];
        for (int i = 0; i < intValues.length; ++i) {
            intValues[i] = this.values[i];
        }
        return intValues;
    }

    public byte[] valuesAsBytes() {
        byte[] byteValues = new byte[this.values.length];
        for (int i = 0; i < byteValues.length; ++i) {
            byteValues[i] = (byte)(0xFF & this.values[i]);
        }
        return byteValues;
    }

    public Byte[] valuesAsAutoBytes() {
        Byte[] byteValues = new Byte[this.values.length];
        for (int i = 0; i < byteValues.length; ++i) {
            byteValues[i] = (byte)(0xFF & this.values[i]);
        }
        return byteValues;
    }

    public void calculate() {
        int size = this.countMap.size();
        int[] frequencies = new int[size];
        int[] values2 = new int[size];
        int i = 0;
        for (Integer key : this.countMap.keySet()) {
            values2[i] = key;
            frequencies[i] = this.countMap.get((Object)key).value;
            ++i;
        }
        HuffmanTree<Integer> tree = HuffmanCode.buildTree(frequencies, HuffmanParamsCalculator.autobox(values2));
        ArrayList valueList = new ArrayList();
        ArrayList<Integer> lens = new ArrayList<Integer>();
        HuffmanCode.getValuesAndBitLengths(valueList, lens, tree);
        Object[] codes = new BitCode[valueList.size()];
        for (i = 0; i < valueList.size(); ++i) {
            codes[i] = new BitCode((Integer)valueList.get(i), (Integer)lens.get(i));
        }
        Arrays.sort(codes);
        this.values = new int[codes.length];
        this.bitLens = new int[codes.length];
        for (i = 0; i < codes.length; ++i) {
            Object code = codes[i];
            this.bitLens[i] = ((BitCode)code).length;
            this.values[i] = ((BitCode)code).value;
        }
    }

    private static Integer[] autobox(int[] array) {
        Integer[] newArray = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    private static class BitCode
    implements Comparable<BitCode> {
        final int value;
        final int length;

        public BitCode(int value, int length) {
            this.value = value;
            this.length = length;
        }

        @Override
        public int compareTo(BitCode o) {
            int result = this.value - o.value;
            if (result != 0) {
                return result;
            }
            return this.length - o.length;
        }
    }
}

