/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanIntegerCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;

public class CanonicalHuffmanIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int[] values;
    private final int[] bitLengths;
    private final ByteBuffer buf;

    public CanonicalHuffmanIntegerEncoding(int[] values2, int[] bitLengths) {
        super(EncodingID.HUFFMAN);
        this.values = values2;
        this.bitLengths = bitLengths;
        this.buf = ByteBuffer.allocate(5 * (values2.length + bitLengths.length));
    }

    public static CanonicalHuffmanIntegerEncoding fromParams(byte[] data) {
        ByteBuffer buf = ByteBuffer.wrap(data);
        int valueSize = ITF8.readUnsignedITF8(buf);
        int[] values2 = new int[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            values2[i] = ITF8.readUnsignedITF8(buf);
        }
        int lengthSize = ITF8.readUnsignedITF8(buf);
        int[] bitLengths = new int[lengthSize];
        for (int i = 0; i < lengthSize; ++i) {
            bitLengths[i] = ITF8.readUnsignedITF8(buf);
        }
        return new CanonicalHuffmanIntegerEncoding(values2, bitLengths);
    }

    @Override
    public byte[] toByteArray() {
        this.buf.clear();
        ITF8.writeUnsignedITF8(this.values.length, this.buf);
        for (int value : this.values) {
            ITF8.writeUnsignedITF8(value, this.buf);
        }
        ITF8.writeUnsignedITF8(this.bitLengths.length, this.buf);
        for (int value : this.bitLengths) {
            ITF8.writeUnsignedITF8(value, this.buf);
        }
        this.buf.flip();
        byte[] array = new byte[this.buf.limit()];
        this.buf.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new CanonicalHuffmanIntegerCodec(coreBlockInputStream, coreBlockOutputStream, this.values, this.bitLengths);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CanonicalHuffmanIntegerEncoding that = (CanonicalHuffmanIntegerEncoding)o;
        return Arrays.equals(this.bitLengths, that.bitLengths) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.bitLengths);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

