/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BetaIntegerCodec;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class BetaIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.BETA;
    private int offset;
    private int bitLimit;

    public BetaIntegerEncoding() {
    }

    public BetaIntegerEncoding(int offset, int bitLimit) {
        this.offset = offset;
        this.bitLimit = bitLimit;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset, int bitLimit) {
        BetaIntegerEncoding encoding = new BetaIntegerEncoding();
        encoding.offset = offset;
        encoding.bitLimit = bitLimit;
        return new EncodingParams(ENCODING_ID, encoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8((int)this.offset, (ByteBuffer)buffer);
        ITF8.writeUnsignedITF8((int)this.bitLimit, (ByteBuffer)buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.offset = ITF8.readUnsignedITF8(buffer);
        this.bitLimit = ITF8.readUnsignedITF8(buffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new BetaIntegerCodec(this.offset, this.bitLimit);
    }
}

