/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.stats;

import hic.tools.utils.iterators.mnd.AlignmentPair;
import hic.tools.utils.iterators.mnd.AlignmentPairLong;
import hic.tools.utils.stats.StatisticsContainer;
import java.util.List;
import java.util.Map;

public abstract class StatisticsWorker {
    protected static final int TWENTY_KB = 20000;
    protected static final int FIVE_HUNDRED_BP = 500;
    protected static final int FIVE_KB = 5000;
    protected static final int distThreshold = 2000;
    protected static final int mapqValThreshold = 200;
    protected static final long[] bins = new long[]{10L, 12L, 15L, 19L, 23L, 28L, 35L, 43L, 53L, 66L, 81L, 100L, 123L, 152L, 187L, 231L, 285L, 351L, 433L, 534L, 658L, 811L, 1000L, 1233L, 1520L, 1874L, 2310L, 2848L, 3511L, 4329L, 5337L, 6579L, 8111L, 10000L, 12328L, 15199L, 18738L, 23101L, 28480L, 35112L, 43288L, 53367L, 65793L, 81113L, 100000L, 123285L, 151991L, 187382L, 231013L, 284804L, 351119L, 432876L, 533670L, 657933L, 811131L, 1000000L, 1232847L, 1519911L, 1873817L, 0x233FF2L, 2848036L, 3511192L, 4328761L, 5336699L, 0x646484L, 8111308L, 10000000L, 12328467L, 15199111L, 18738174L, 23101297L, 28480359L, 35111917L, 43287613L, 53366992L, 65793322L, 81113083L, 100000000L, 123284674L, 151991108L, 187381742L, 231012970L, 284803587L, 351119173L, 432876128L, 533669923L, 657933225L, 811130831L, 1000000000L, 1232846739L, 1519911083L, 1873817423L, 2310129700L, 2848035868L, 3511191734L, 4328761281L, 5336699231L, 6579332247L, 8111308308L, 10000000000L};
    protected final String siteFile;
    protected final String inFile;
    protected final String danglingJunction;
    protected final String ligationJunction;
    protected final List<String> statsFiles;
    protected final List<Integer> mapqThresholds;
    protected final StatisticsContainer resultsContainer;

    public StatisticsWorker(String siteFile, List<String> statsFiles, List<Integer> mapqThresholds, String ligationJunction, String inFile) {
        this.inFile = inFile;
        this.siteFile = siteFile;
        this.statsFiles = statsFiles;
        this.mapqThresholds = mapqThresholds;
        this.ligationJunction = ligationJunction;
        this.resultsContainer = new StatisticsContainer();
        this.danglingJunction = ligationJunction.substring(ligationJunction.length() / 2);
    }

    public StatisticsContainer getResultsContainer() {
        return this.resultsContainer;
    }

    protected boolean processSingleEntry(AlignmentPair pair, String blockKey, boolean multithread) {
        int chr1 = pair.getChr1();
        int chr2 = pair.getChr2();
        String currentBlock = chr1 + "_" + chr2;
        if (multithread && !currentBlock.equals(blockKey)) {
            return true;
        }
        int pos1 = pair.getPos1();
        int pos2 = pair.getPos2();
        int frag1 = pair.getFrag1();
        int frag2 = pair.getFrag2();
        int mapq1 = pair.getMapq1();
        int mapq2 = pair.getMapq2();
        boolean str1 = pair.getStrand1();
        boolean str2 = pair.getStrand2();
        ++this.resultsContainer.unique;
        for (int ind = 0; ind < this.statsFiles.size(); ++ind) {
            String seq2;
            String seq1;
            int mapqValue;
            boolean countMe = pair.isValid();
            if (chr1 == chr2 && frag1 == frag2) {
                int n = ind;
                this.resultsContainer.intraFragment[n] = this.resultsContainer.intraFragment[n] + 1L;
                countMe = false;
            } else if (!pair.isShort() && mapq1 >= 0 && mapq2 >= 0 && (mapqValue = Math.min(mapq1, mapq2)) < this.mapqThresholds.get(ind)) {
                int n = ind;
                this.resultsContainer.underMapQ[n] = this.resultsContainer.underMapQ[n] + 1L;
                countMe = false;
            }
            if (!countMe || this.statsFiles.get(ind) == null) continue;
            int n = ind;
            this.resultsContainer.totalCurrent[n] = this.resultsContainer.totalCurrent[n] + 1L;
            int posDist = Math.abs(pos1 - pos2);
            int histDist = StatisticsWorker.bSearch(posDist);
            boolean isDangling = false;
            if (pair instanceof AlignmentPairLong) {
                AlignmentPairLong longPair = (AlignmentPairLong)pair;
                seq1 = longPair.getSeq1();
                seq2 = longPair.getSeq2();
                if (seq1 != null && seq2 != null && (seq1.startsWith(this.danglingJunction) || seq2.startsWith(this.danglingJunction))) {
                    int n2 = ind;
                    this.resultsContainer.dangling[n2] = this.resultsContainer.dangling[n2] + 1L;
                    isDangling = true;
                }
            }
            if (chr1 == chr2) {
                boolean distGT20KB;
                int n3 = ind;
                this.resultsContainer.intra[n3] = this.resultsContainer.intra[n3] + 1L;
                boolean bl = distGT20KB = posDist >= 20000;
                if (str1 == str2) {
                    if (str1) {
                        this.populateLIOR(distGT20KB, this.resultsContainer.right, this.resultsContainer.rightM, ind, histDist);
                    } else {
                        this.populateLIOR(distGT20KB, this.resultsContainer.left, this.resultsContainer.leftM, ind, histDist);
                    }
                } else if (str1) {
                    if (pos1 < pos2) {
                        this.populateLIOR(distGT20KB, this.resultsContainer.inner, this.resultsContainer.innerM, ind, histDist);
                    } else {
                        this.populateLIOR(distGT20KB, this.resultsContainer.outer, this.resultsContainer.outerM, ind, histDist);
                    }
                } else if (pos1 < pos2) {
                    this.populateLIOR(distGT20KB, this.resultsContainer.outer, this.resultsContainer.outerM, ind, histDist);
                } else {
                    this.populateLIOR(distGT20KB, this.resultsContainer.inner, this.resultsContainer.innerM, ind, histDist);
                }
                if (posDist < 500) {
                    this.populateDist(this.resultsContainer.fiveHundredBPRes, this.resultsContainer.fiveHundredBPResDangling, ind, isDangling);
                } else if (posDist < 5000) {
                    this.populateDist(this.resultsContainer.fiveKBRes, this.resultsContainer.fiveKBResDangling, ind, isDangling);
                } else if (posDist < 20000) {
                    this.populateDist(this.resultsContainer.twentyKBRes, this.resultsContainer.twentyKBResDangling, ind, isDangling);
                } else {
                    this.populateDist(this.resultsContainer.large, this.resultsContainer.largeDangling, ind, isDangling);
                }
            } else {
                this.populateDist(this.resultsContainer.inter, this.resultsContainer.interDangling, ind, isDangling);
            }
            if (!(pair instanceof AlignmentPairLong)) continue;
            AlignmentPairLong longPair = (AlignmentPairLong)pair;
            seq1 = longPair.getSeq1();
            seq2 = longPair.getSeq2();
            if (seq1 == null || seq2 == null || mapq1 < 0 || mapq2 < 0) continue;
            int mapqVal = Math.min(mapq1, mapq2);
            if (mapqVal <= 200) {
                this.resultsContainer.mapQ.get(ind).put(mapqVal, this.resultsContainer.mapQ.get(ind).getOrDefault(mapqVal, 0L) + 1L);
                if (chr1 == chr2) {
                    this.resultsContainer.mapQIntra.get(ind).put(mapqVal, this.resultsContainer.mapQIntra.get(ind).getOrDefault(mapqVal, 0L) + 1L);
                } else {
                    this.resultsContainer.mapQInter.get(ind).put(mapqVal, this.resultsContainer.mapQInter.get(ind).getOrDefault(mapqVal, 0L) + 1L);
                }
            }
            if (!seq1.contains(this.ligationJunction) && !seq2.contains(this.ligationJunction)) continue;
            int n4 = ind;
            this.resultsContainer.ligation[n4] = this.resultsContainer.ligation[n4] + 1L;
        }
        return false;
    }

    private void populateDist(long[] array, long[] arrayDangling, int ind, boolean isDangling) {
        int n = ind;
        array[n] = array[n] + 1L;
        if (isDangling) {
            int n2 = ind;
            arrayDangling[n2] = arrayDangling[n2] + 1L;
        }
    }

    private void populateLIOR(boolean distGT20KB, long[] array, List<Map<Integer, Long>> arrayM, int ind, int histDist) {
        if (distGT20KB) {
            int n = ind;
            array[n] = array[n] + 1L;
        }
        arrayM.get(ind).put(histDist, arrayM.get(ind).getOrDefault(histDist, 0L) + 1L);
    }

    private static int bSearch(int distance) {
        int lower = 0;
        int upper = bins.length - 1;
        while (lower <= upper) {
            int index = (lower + upper) / 2;
            if (bins[index] < (long)distance) {
                lower = index + 1;
                continue;
            }
            if (bins[index] > (long)distance) {
                upper = index - 1;
                continue;
            }
            return index;
        }
        return lower;
    }
}

