/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.stats;

import hic.tools.clt.old.LibraryComplexity;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StatisticsContainer {
    private static final float CONVERGENCE_THRESHOLD = 0.01f;
    private static final int CONVERGENCE_REGION = 3;
    private static final int SEQ_INDEX = 0;
    private static final int DUPS_INDEX = 1;
    private static final int UNIQUE_INDEX = 2;
    private static final int LC_INDEX = 3;
    private static final int SINGLE_ALIGNMENT_INDEX = 4;
    private static final int SINGLE_ALIGN_DUPS_INDEX = 5;
    private static final int SINGLE_ALIGN_UNIQUE_INDEX = 6;
    private static final int NUM_TO_READ = 7;
    private final NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
    public final List<Map<Integer, Long>> hindIII = new ArrayList<Map<Integer, Long>>();
    public final List<Map<Integer, Long>> mapQ = new ArrayList<Map<Integer, Long>>();
    public final List<Map<Integer, Long>> mapQInter = new ArrayList<Map<Integer, Long>>();
    public final List<Map<Integer, Long>> mapQIntra = new ArrayList<Map<Integer, Long>>();
    public final List<Map<Integer, Long>> innerM = new ArrayList<Map<Integer, Long>>();
    public final List<Map<Integer, Long>> outerM = new ArrayList<Map<Integer, Long>>();
    public final List<Map<Integer, Long>> rightM = new ArrayList<Map<Integer, Long>>();
    public final List<Map<Integer, Long>> leftM = new ArrayList<Map<Integer, Long>>();
    private final List<Integer> convergenceIndices = new ArrayList<Integer>();
    public long unique = 0L;
    public final long[] intraFragment = new long[2];
    public final long[] threePrimeEnd = new long[2];
    public final long[] fivePrimeEnd = new long[2];
    public final long[] dangling = new long[2];
    public final long[] ligation = new long[2];
    public final long[] inner = new long[2];
    public final long[] outer = new long[2];
    public final long[] left = new long[2];
    public final long[] right = new long[2];
    public final long[] intra = new long[2];
    public final long[] inter = new long[2];
    public final long[] interDangling = new long[2];
    public final long[] trueDanglingIntraSmall = new long[2];
    public final long[] trueDanglingIntraLarge = new long[2];
    public final long[] trueDanglingInter = new long[2];
    public final long[] totalCurrent = new long[2];
    public final long[] underMapQ = new long[2];
    public final long[] fiveHundredBPRes = new long[2];
    public final long[] fiveHundredBPResDangling = new long[2];
    public final long[] fiveKBRes = new long[2];
    public final long[] fiveKBResDangling = new long[2];
    public final long[] twentyKBRes = new long[2];
    public final long[] twentyKBResDangling = new long[2];
    public final long[] large = new long[2];
    public final long[] largeDangling = new long[2];
    private static final long[] bins = new long[]{10L, 12L, 15L, 19L, 23L, 28L, 35L, 43L, 53L, 66L, 81L, 100L, 123L, 152L, 187L, 231L, 285L, 351L, 433L, 534L, 658L, 811L, 1000L, 1233L, 1520L, 1874L, 2310L, 2848L, 3511L, 4329L, 5337L, 6579L, 8111L, 10000L, 12328L, 15199L, 18738L, 23101L, 28480L, 35112L, 43288L, 53367L, 65793L, 81113L, 100000L, 123285L, 151991L, 187382L, 231013L, 284804L, 351119L, 432876L, 533670L, 657933L, 811131L, 1000000L, 1232847L, 1519911L, 1873817L, 0x233FF2L, 2848036L, 3511192L, 4328761L, 5336699L, 0x646484L, 8111308L, 10000000L, 12328467L, 15199111L, 18738174L, 23101297L, 28480359L, 35111917L, 43287613L, 53366992L, 65793322L, 81113083L, 100000000L, 123284674L, 151991108L, 187381742L, 231012970L, 284803587L, 351119173L, 432876128L, 533669923L, 657933225L, 811130831L, 1000000000L, 1232846739L, 1519911083L, 1873817423L, 2310129700L, 2848035868L, 3511191734L, 4328761281L, 5336699231L, 6579332247L, 8111308308L, 10000000000L};

    public StatisticsContainer() {
        for (int i = 0; i < 2; ++i) {
            this.hindIII.add(new HashMap());
            this.mapQ.add(new HashMap());
            this.mapQInter.add(new HashMap());
            this.mapQIntra.add(new HashMap());
            this.innerM.add(new HashMap());
            this.outerM.add(new HashMap());
            this.rightM.add(new HashMap());
            this.leftM.add(new HashMap());
        }
    }

    public void add(StatisticsContainer individualContainer, int numberOfMapQValues) {
        this.unique += individualContainer.unique;
        for (int j = 0; j < numberOfMapQValues; ++j) {
            int i;
            for (i = 1; i <= 2000; ++i) {
                this.hindIII.get(j).put(i, this.hindIII.get(j).getOrDefault(i, 0L) + individualContainer.hindIII.get(j).getOrDefault(i, 0L));
            }
            for (i = 1; i <= 200; ++i) {
                this.mapQ.get(j).put(i, this.mapQ.get(j).getOrDefault(i, 0L) + individualContainer.mapQ.get(j).getOrDefault(i, 0L));
                this.mapQInter.get(j).put(i, this.mapQInter.get(j).getOrDefault(i, 0L) + individualContainer.mapQInter.get(j).getOrDefault(i, 0L));
                this.mapQIntra.get(j).put(i, this.mapQIntra.get(j).getOrDefault(i, 0L) + individualContainer.mapQIntra.get(j).getOrDefault(i, 0L));
            }
            for (i = 1; i <= 100; ++i) {
                this.innerM.get(j).put(i, this.innerM.get(j).getOrDefault(i, 0L) + individualContainer.innerM.get(j).getOrDefault(i, 0L));
                this.outerM.get(j).put(i, this.outerM.get(j).getOrDefault(i, 0L) + individualContainer.outerM.get(j).getOrDefault(i, 0L));
                this.rightM.get(j).put(i, this.rightM.get(j).getOrDefault(i, 0L) + individualContainer.rightM.get(j).getOrDefault(i, 0L));
                this.leftM.get(j).put(i, this.leftM.get(j).getOrDefault(i, 0L) + individualContainer.leftM.get(j).getOrDefault(i, 0L));
            }
        }
        for (int i = 0; i < numberOfMapQValues; ++i) {
            int n = i;
            this.intraFragment[n] = this.intraFragment[n] + individualContainer.intraFragment[i];
            int n2 = i;
            this.threePrimeEnd[n2] = this.threePrimeEnd[n2] + individualContainer.threePrimeEnd[i];
            int n3 = i;
            this.fivePrimeEnd[n3] = this.fivePrimeEnd[n3] + individualContainer.fivePrimeEnd[i];
            int n4 = i;
            this.dangling[n4] = this.dangling[n4] + individualContainer.dangling[i];
            int n5 = i;
            this.ligation[n5] = this.ligation[n5] + individualContainer.ligation[i];
            int n6 = i;
            this.inner[n6] = this.inner[n6] + individualContainer.inner[i];
            int n7 = i;
            this.outer[n7] = this.outer[n7] + individualContainer.outer[i];
            int n8 = i;
            this.left[n8] = this.left[n8] + individualContainer.left[i];
            int n9 = i;
            this.right[n9] = this.right[n9] + individualContainer.right[i];
            int n10 = i;
            this.intra[n10] = this.intra[n10] + individualContainer.intra[i];
            int n11 = i;
            this.inter[n11] = this.inter[n11] + individualContainer.inter[i];
            int n12 = i;
            this.large[n12] = this.large[n12] + individualContainer.large[i];
            int n13 = i;
            this.twentyKBRes[n13] = this.twentyKBRes[n13] + individualContainer.twentyKBRes[i];
            int n14 = i;
            this.fiveKBRes[n14] = this.fiveKBRes[n14] + individualContainer.fiveKBRes[i];
            int n15 = i;
            this.fiveHundredBPRes[n15] = this.fiveHundredBPRes[n15] + individualContainer.fiveHundredBPRes[i];
            int n16 = i;
            this.fiveHundredBPResDangling[n16] = this.fiveHundredBPResDangling[n16] + individualContainer.fiveHundredBPResDangling[i];
            int n17 = i;
            this.fiveKBResDangling[n17] = this.fiveKBResDangling[n17] + individualContainer.fiveKBResDangling[i];
            int n18 = i;
            this.twentyKBResDangling[n18] = this.twentyKBResDangling[n18] + individualContainer.twentyKBResDangling[i];
            int n19 = i;
            this.largeDangling[n19] = this.largeDangling[n19] + individualContainer.largeDangling[i];
            int n20 = i;
            this.interDangling[n20] = this.interDangling[n20] + individualContainer.interDangling[i];
            int n21 = i;
            this.trueDanglingIntraSmall[n21] = this.trueDanglingIntraSmall[n21] + individualContainer.trueDanglingIntraSmall[i];
            int n22 = i;
            this.trueDanglingIntraLarge[n22] = this.trueDanglingIntraLarge[n22] + individualContainer.trueDanglingIntraLarge[i];
            int n23 = i;
            this.trueDanglingInter[n23] = this.trueDanglingInter[n23] + individualContainer.trueDanglingInter[i];
            int n24 = i;
            this.totalCurrent[n24] = this.totalCurrent[n24] + individualContainer.totalCurrent[i];
            int n25 = i;
            this.underMapQ[n25] = this.underMapQ[n25] + individualContainer.underMapQ[i];
        }
    }

    private String commify(long value) {
        return this.nf.format(value);
    }

    private String percentify(long num, long total) {
        return String.format("%.2f", Float.valueOf((float)num * 100.0f / (float)total)) + "%";
    }

    private String wholePercentify(long num, long total) {
        return String.format("%.0f", Float.valueOf((float)num * 100.0f / (float)total)) + "%";
    }

    public void outputStatsFile(List<String> statsFiles) {
        for (int i = 0; i < statsFiles.size(); ++i) {
            File statFile = new File(statsFiles.get(i));
            boolean[] valsWereFound = new boolean[7];
            long[] valsFound = new long[7];
            this.attempReadingDataFromExistingFile(valsWereFound, valsFound, statFile);
            try {
                BufferedWriter statsOut = new BufferedWriter(new FileWriter(statFile, true));
                this.writeLibComplexityIfNeeded(valsWereFound, valsFound, statsOut);
                if (this.unique == 0L) {
                    this.unique = 1L;
                }
                this.writeOut(statsOut, "Intra-fragment Reads: ", valsWereFound, this.intraFragment[i], valsFound, this.unique, true);
                this.attemptMapqCorrection(valsWereFound, valsFound, this.underMapQ, this.unique, i);
                this.writeOut(statsOut, "Below MAPQ Threshold: ", valsWereFound, this.underMapQ[i], valsFound, this.unique, true);
                this.writeOut(statsOut, "Hi-C Contacts: ", valsWereFound, this.totalCurrent[i], valsFound, this.unique, false);
                this.appendPairTypeStatsOutputToFile(i, statsOut);
                this.writeOut(statsOut, "Inter-chromosomal: ", valsWereFound, this.inter[i], valsFound, this.unique, false);
                this.writeOut(statsOut, "Intra-chromosomal: ", valsWereFound, this.intra[i], valsFound, this.unique, false);
                statsOut.write("Short Range (<20Kb):\n");
                this.writeOut(statsOut, "  <500BP: ", valsWereFound, this.fiveHundredBPRes[i], valsFound, this.unique, false);
                this.writeOut(statsOut, "  500BP-5kB: ", valsWereFound, this.fiveKBRes[i], valsFound, this.unique, false);
                this.writeOut(statsOut, "  5kB-20kB: ", valsWereFound, this.twentyKBRes[i], valsFound, this.unique, false);
                this.writeOut(statsOut, "Long Range (>20Kb): ", valsWereFound, this.large[i], valsFound, this.unique, false);
                statsOut.close();
                continue;
            }
            catch (IOException error) {
                error.printStackTrace();
            }
        }
    }

    private boolean isUTLibrary(boolean[] valsWereFound, long[] valsFound, long belowMapQ) {
        return valsWereFound[4] && valsFound[4] > 0L && belowMapQ < 1L;
    }

    private void writeLibComplexityIfNeeded(boolean[] valsWereFound, long[] valsFound, BufferedWriter statsOut) throws IOException {
        if (!valsWereFound[3]) {
            boolean isUTExperiment = false;
            long lcTotal = 0L;
            if (valsWereFound[6] && valsWereFound[5]) {
                long resultLC1 = LibraryComplexity.estimateLibrarySize(valsFound[5], valsFound[6]);
                isUTExperiment = true;
                if (resultLC1 > 0L) {
                    lcTotal += resultLC1;
                    statsOut.write("Library Complexity Estimate (1 alignment)*: " + this.commify(resultLC1) + "\n");
                } else {
                    statsOut.write("Library Complexity Estimate (1 alignment)*: N/A\n");
                }
            }
            if (valsWereFound[2] && valsWereFound[1]) {
                long resultLC2 = LibraryComplexity.estimateLibrarySize(valsFound[1], valsFound[2]);
                String description = "";
                if (isUTExperiment) {
                    description = " (2 alignments)";
                }
                if (resultLC2 > 0L) {
                    lcTotal += resultLC2;
                    statsOut.write("Library Complexity Estimate" + description + "*: " + this.commify(resultLC2) + "\n");
                } else {
                    statsOut.write("Library Complexity Estimate" + description + "*: N/A\n");
                }
            }
            if (isUTExperiment) {
                if (lcTotal > 0L) {
                    statsOut.write("Library Complexity Estimate (1+2 above)*: " + this.commify(lcTotal) + "\n");
                } else {
                    statsOut.write("Library Complexity Estimate (1+2 above)*: N/A\n");
                }
            }
        }
    }

    private void attempReadingDataFromExistingFile(boolean[] valsWereFound, long[] valsFound, File statFile) {
        Arrays.fill(valsWereFound, false);
        Arrays.fill(valsFound, 0L);
        if (statFile.exists()) {
            try {
                BufferedReader stats = new BufferedReader(new FileReader(statFile));
                String statsData = stats.readLine();
                while (statsData != null) {
                    if ((statsData = statsData.toLowerCase()).contains("sequenced")) {
                        this.populateFoundVals(statsData, valsWereFound, valsFound, 0);
                    } else if (statsData.contains("unique")) {
                        if (this.isSingleAlignment(statsData)) {
                            this.populateFoundVals(statsData, valsWereFound, valsFound, 6);
                        } else {
                            this.populateFoundVals(statsData, valsWereFound, valsFound, 2);
                        }
                    } else if (statsData.contains("duplicate") && !statsData.contains("optical")) {
                        if (this.isSingleAlignment(statsData)) {
                            this.populateFoundVals(statsData, valsWereFound, valsFound, 5);
                        } else {
                            this.populateFoundVals(statsData, valsWereFound, valsFound, 1);
                        }
                    } else if (statsData.contains("complexity")) {
                        this.populateFoundVals(statsData, valsWereFound, valsFound, 3);
                    } else if (statsData.contains("single") && statsData.contains("alignment")) {
                        this.populateFoundVals(statsData, valsWereFound, valsFound, 4);
                    }
                    statsData = stats.readLine();
                }
                stats.close();
            }
            catch (IOException error) {
                error.printStackTrace();
            }
        }
    }

    private boolean isSingleAlignment(String text) {
        String[] tokens2 = text.split(":");
        String description = tokens2[0].toLowerCase();
        return (description.contains("1") || description.contains("one")) && description.contains("alignment");
    }

    private void populateFoundVals(String statsData, boolean[] valsWereFound, long[] valsFound, int index) {
        if (!valsWereFound[index]) {
            valsWereFound[index] = true;
            String[] tokens2 = statsData.split(":");
            String substring1 = tokens2[1].replaceAll("[, ]", "");
            if (substring1.contains("(")) {
                substring1 = substring1.split("\\(")[0];
            }
            valsFound[index] = Long.parseLong(substring1.trim());
        }
    }

    private void attemptMapqCorrection(boolean[] valsWereGiven, long[] valsFound, long[] underMapQ, long unique, int i) {
        if (underMapQ[i] < 1L && valsWereGiven[2]) {
            underMapQ[i] = valsFound[2] - unique;
        }
    }

    void appendPairTypeStatsOutputToFile(int i, BufferedWriter statsOut) throws IOException {
        if (this.fivePrimeEnd[i] + this.threePrimeEnd[i] > 0L) {
            statsOut.write(" 3' Bias (Long Range): " + this.wholePercentify(this.threePrimeEnd[i], this.threePrimeEnd[i] + this.fivePrimeEnd[i]));
            statsOut.write(" - " + this.wholePercentify(this.fivePrimeEnd[i], this.threePrimeEnd[i] + this.fivePrimeEnd[i]) + "\n");
        } else {
            statsOut.write(" 3' Bias (Long Range): N/A\n");
        }
        if (this.large[i] > 0L) {
            statsOut.write(" Pair Type %(L-I-O-R): " + this.wholePercentify(this.left[i], this.large[i]));
            statsOut.write(" - " + this.wholePercentify(this.inner[i], this.large[i]));
            statsOut.write(" - " + this.wholePercentify(this.outer[i], this.large[i]));
            statsOut.write(" - " + this.wholePercentify(this.right[i], this.large[i]) + "\n");
            statsOut.write(" L-I-O-R Convergence: " + bins[this.convergenceIndices.get(i)] + "\n");
        } else {
            statsOut.write(" Pair Type %(L-I-O-R): N/A\n");
        }
    }

    private void writeOut(BufferedWriter statsOut, String description, boolean[] valsWereGiven, long value, long[] valsFound, long unique, boolean checkNA) throws IOException {
        if (!checkNA || value > 0L) {
            if (valsWereGiven[0] && valsWereGiven[2]) {
                statsOut.write(description + this.commify(value) + " (" + this.percentify(value, valsFound[0]) + " / " + this.percentify(value, valsFound[2]) + ")\n");
            } else {
                statsOut.write(description + this.commify(value) + " (" + this.percentify(value, unique) + ")\n");
            }
        } else {
            statsOut.write(description + "N/A\n");
        }
    }

    public void writeHistFile(List<String> statsFiles) {
        for (int j = 0; j < statsFiles.size(); ++j) {
            if (!new File(statsFiles.get(j)).exists()) continue;
            int index = statsFiles.get(j).lastIndexOf("\\");
            String statsFilePath = statsFiles.get(j).substring(0, index + 1);
            String statsFileName = statsFiles.get(j).substring(index + 1).replaceAll(".txt", "");
            String histsFile = statsFilePath + statsFileName + "_hists.m";
            try {
                long tmp3;
                long tmp2;
                long tmp;
                int i;
                BufferedWriter hist = new BufferedWriter(new FileWriter(histsFile, false));
                hist.write("A = [\n");
                for (i = 1; i <= 2000; ++i) {
                    tmp = this.hindIII.get(j).getOrDefault(i, 0L);
                    hist.write(tmp + " ");
                }
                hist.write("\n];\n");
                hist.write("B = [\n");
                for (i = 1; i <= 200; ++i) {
                    tmp = this.mapQ.get(j).getOrDefault(i, 0L);
                    tmp2 = this.mapQIntra.get(j).getOrDefault(i, 0L);
                    tmp3 = this.mapQInter.get(j).getOrDefault(i, 0L);
                    hist.write(tmp + " " + tmp2 + " " + tmp3 + "\n");
                }
                hist.write("\n];\n");
                hist.write("D = [\n");
                for (i = 0; i < bins.length; ++i) {
                    tmp = this.innerM.get(j).getOrDefault(i, 0L);
                    tmp2 = this.outerM.get(j).getOrDefault(i, 0L);
                    tmp3 = this.rightM.get(j).getOrDefault(i, 0L);
                    long tmp4 = this.leftM.get(j).getOrDefault(i, 0L);
                    hist.write(tmp + " " + tmp2 + " " + tmp3 + " " + tmp4 + "\n");
                }
                hist.write("\n];");
                hist.write("x = [\n");
                for (long bin : bins) {
                    hist.write(bin + " ");
                }
                hist.write("\n];\n");
                hist.close();
                continue;
            }
            catch (IOException error) {
                error.printStackTrace();
            }
        }
    }

    public void calculateConvergence(int numMapQs) {
        this.convergenceIndices.clear();
        for (int q = 0; q < numMapQs; ++q) {
            int index = -1;
            boolean solutionFound = false;
            while (!solutionFound && index < bins.length - 1) {
                if (!(this.getConvergenceError(q, ++index) < (double)0.01f)) continue;
                solutionFound = this.confirmConvergenceMaintained(q, index + 1, bins.length);
            }
            this.convergenceIndices.add(index);
        }
    }

    private boolean confirmConvergenceMaintained(int q, int startIndex, int maxIndex) {
        boolean convergenceMaintained = true;
        for (int i = startIndex; i < Math.min(startIndex + 3, maxIndex); ++i) {
            double error = this.getConvergenceError(q, i);
            convergenceMaintained &= error < (double)0.01f;
        }
        return convergenceMaintained;
    }

    private double getConvergenceError(int q, int i) {
        long[] vals = new long[]{this.innerM.get(q).getOrDefault(i, 0L), this.outerM.get(q).getOrDefault(i, 0L), this.rightM.get(q).getOrDefault(i, 0L), this.leftM.get(q).getOrDefault(i, 0L)};
        double total = 0.0;
        for (long val : vals) {
            total += (double)val;
        }
        if (total < 1.0) {
            return 1000.0;
        }
        double logAvg = Math.log(total / 4.0);
        double error = 0.0;
        for (long val : vals) {
            double tempErr = (logAvg - Math.log(val)) / logAvg;
            error = Math.max(error, Math.abs(tempErr));
        }
        return error;
    }
}

