/*
 * Decompiled with CFR 0.152.
 */
package hic.tools.utils.stats;

import hic.tools.utils.iterators.mnd.AlignmentPairLong;
import hic.tools.utils.iterators.mnd.AsciiPairIterator;
import hic.tools.utils.original.Chunk;
import hic.tools.utils.stats.StatisticsWorker;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javastraw.reader.basics.ChromosomeHandler;

public class ParallelStatisticsWorker
extends StatisticsWorker {
    private final ChromosomeHandler localHandler;

    public ParallelStatisticsWorker(String siteFile, List<String> statsFiles, List<Integer> mapqThresholds, String ligationJunction, String inFile, ChromosomeHandler localHandler) {
        super(siteFile, statsFiles, mapqThresholds, ligationJunction, inFile);
        this.localHandler = localHandler;
    }

    public void infileStatistics(Chunk chunk) {
        try {
            HashMap<String, Integer> chromosomeIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.localHandler.size(); ++i) {
                chromosomeIndexes.put(this.localHandler.getChromosomeFromIndex(i).getName(), i);
            }
            AsciiPairIterator files = new AsciiPairIterator(this.inFile, chromosomeIndexes, chunk, this.localHandler);
            if (files.hasNext()) {
                AlignmentPairLong pair;
                AlignmentPairLong firstPair = (AlignmentPairLong)files.next();
                String previousBlock = firstPair.getChr1() + "_" + firstPair.getChr2();
                this.processSingleEntry(firstPair, previousBlock, true);
                while (files.hasNext() && !this.processSingleEntry(pair = (AlignmentPairLong)files.next(), previousBlock, true)) {
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String getChromosomeNameFromIndex(int chr) {
        return this.localHandler.getChromosomeFromIndex(chr).getName();
    }
}

